#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <wfdb/wfdb.h>
#include <wfdb/ecgmap.h>


#define MAX_LEADS 10
#define MAX_SIGS  10
#define MAX_LEN   310000000
#define MAX_BUF   1000000
#define MAX_GAP   10000

static WFDB_Siginfo s[MAX_LEADS];

//double step1(long sample); // L HPF
//double step2(long sample); // NL LPF

long getMini(double *sig, long sigLen, long start, long len);
long getMaxi(double *sig, long sigLen, long start, long len);
int isAnn(int *sig, long sigLen, long start, long len);
void highPass();
void lowPass();
void QRS();

long nrSamps;
double *sig0;
double *sig1;
double *sig2;

int *annqrs;
int *bpann;
int *finalann;

double *bp0;

int openLeads;
long samples;
double normCnst = 32;




int openRecord(char *record) {
	return (isigopen(record, s, MAX_LEADS));
}

long ReadBuffer(long annot) {
	long i;
	WFDB_Sample vec[MAX_LEADS];

	for (i = 0; i < nrSamps; i++) {
		if (getvec(vec) < 0) {
			break;
		}
		sig0[i] = vec[0];
		bp0[i] = vec[1];
	}

	return(i);
}

void detectQRS() {
	printf("detectQRS\n");

	// ----- ECG -----

	highPass();
	lowPass();
	QRS();

	// ----- TEST OUTPUT -----
	FILE *f = fopen("ecg.txt", "w");
	if (f == NULL)
	{
	    printf("Error opening file!\n");
	    exit(1);
	}
	long i;
	long start = 20300;
	long d = 1600;
	for(i=start; i<samples && i<start+d; i++)
		fprintf(f, "%f\t%f\t%f\t%d\t%d\n", sig0[i], sig1[i], sig2[i], annqrs[i]==0 ? 0 : 70000, annqrs[i]==0 ? -500 : 0);
	fclose(f);



	// ----- BLOOD PRESSURE -----

	int ZAMIK = 70; // #samplov med QRS in BP vrhom
	double bpThreshold = 200; // min razlike med min in max, da se steje kot vrh

	long mini;
	long maxi;
	i = 0;
	do{
		//najdem minimum med 1. 350 vzorci
		mini = getMini(bp0, samples, i, i+200);

		//najdem max od mina naprej
		maxi = getMaxi(bp0, samples, mini, mini+60);

		if(maxi>=0 && maxi-ZAMIK >= 0 && (bp0[maxi]-bp0[mini])>bpThreshold){
			bpann[maxi-ZAMIK] = 1;
			i = maxi+50;
		}
		else
			i = mini+5;

	}while(i<samples && i>0 && mini>0);


	// ----- COMBINE ECG & BP -----

	int MIN_BEAT_DIST_SAMPLES = 58;
	int MAX_BEAT_DIST_SAMPLES = 200;
	int ecgBp = isAnn(bpann, samples, 0, 500);
	long lastBeat = 0;
	int p = 0;
	for(i=0; i<samples; i++){
		if(ecgBp==0 && bpann[i]==1)
			ecgBp = 1;

		int t = (ecgBp==0 ? annqrs[i] : bpann[i]);
		
//		if(i-lastBeat < MIN_BEAT_DIST_SAMPLES && lastBeat>0)
//			continue;
		if(i == p){
			p = 0;
		}
		if(ecgBp == 1 && i-lastBeat > MAX_BEAT_DIST_SAMPLES && p==0){
			p = i+1;
			i = lastBeat+MIN_BEAT_DIST_SAMPLES;
			ecgBp = 0;
			continue;
		}

		finalann[i] = t;
		
		if(t==1){
			lastBeat = i;
			i += MIN_BEAT_DIST_SAMPLES;
		}
		
	}


	// ----- TEST OUTPUT -----
	f = fopen("sigs.txt", "w");
	if (f == NULL)
	{
	    printf("Error opening file!\n");
	    exit(1);
	}
	for(i=start; i<samples && i<start+d; i++)
		fprintf(f, "%f\t%f\t%d\t%d\t%d\t%d\n", sig0[i], bp0[i], bpann[i]==0 ? -500 : 60, annqrs[i]==0 ? -490 : -100, finalann[i]==0 ? -500 : 100, finalann[i]==annqrs[i] ? -400 : -300);
	fclose(f);
}

void highPass(){
	printf("highPass\n");

	int M = 5;
	double constant = 1.0/M;

	int i;
	for(i=0; i<samples; i++){
		double y1=0, y2=0;

		//-
		if(i>=M){
			int m;
			for(m=0; m<M; m++)
				y1 += sig0[i-m];
		}
		y1 = y1 / M;

		if(i >= ((M+1)/2))
			y2 = sig0[i-((M+1)/2)];
		//-

/*
		int y2i = i-((M+1)/2);
		if(y2i < 0)
			y2i = samples + y2i;
		y2i = sig0[y2i];

		double y1sum = 0;
		int j;
		for(j=i; j>i-M; j--)
			y1sum += sig0[j<0 ? j+samples : j];
		
		y1 = constant * y1sum;*/

		sig1[i] = y2-y1;
	}
}

void lowPass(){
	printf("lowPass1\n");

	int window = 38;


	int i;
	for(i=0; i<samples; i++){
		int j;
		for(j=i; j < i + window && j < samples; j++){
			sig2[i] += sig1[j] * sig1[j];
		}
	}
/*
	int i;
	for(i=0; i<samples; i++){
		double sum = 0;
		if(i+window < samples){
			int j;
			for(j=i; j<i+window; j++)
				sum += sig1[j] * sig1[j];
		}else{
			int j;
			for(j=i; j<samples; j++)
				sum += sig1[j] * sig1[j];
			for(j=0; j < i+window-samples; j++)
				sum += sig1[j] * sig1[j];
		}
		sig2[i] = sum;
	}*/
}

void QRS(){
	printf("QRS\n");

	double alpha = 0.05;
	double gamma = 0.15;

	int i;
	//če 500 samplov ni nič (mrtev?) ponovno nastavi thresh tako kot na začetku

	double thresh = sig2[getMaxi(sig2, samples, 0, 250)];
	
	int frame = 250;

	long ba = -1;
	long nic = 0;
	for(i=0; i<samples; i++){
		if(sig2[i]>=thresh){
			ba = i;
			//printf("ba%d\n", ba);
		}else if(ba>=0){
			annqrs[i] = 1;
			ba = -1;
			i+=100;
			nic = i;

			double max = sig2[getMaxi(sig2, samples, ba, i)];
			thresh = alpha * gamma * max + (1-alpha) * thresh;
		}else if(i > nic+500){
			thresh = sig2[getMaxi(sig2, samples, nic+100, nic+350)];
			i = nic+100;
			nic = i;
		}
	}

/*
	for(i=0; i<samples; i+=frame){
		double max = 0;
		int mi = i+frame>samples ? samples : i+frame;

		int j;
		for(j=i; j<mi; j++)
			if(sig2[j] > max)
				max = sig2[j];
		
		int a = 0;
		for(j=i; j<mi; j++){
			if(sig2[j] > thresh && a==0){
				annqrs[j] = 1;
				a = 1;
			}else
				annqrs[j] = 0;
		}

		thresh = alpha * gamma * max + (1-alpha) * thresh;
	}*/
}

long getMini(double *sig, long sigLen, long start, long len){
	long i;
	double min = 999999;
	long mini = -1;
	for(i=start; i<len && i<sigLen; i++){
		if(sig[i]<min){
			min = sig[i];
			mini = i;
		}
	}
	return mini;
}

long getMaxi(double *sig, long sigLen, long start, long len){
	long i;
	double max = -999999;
	long maxi = -1;
	for(i=start; i<len && i<sigLen; i++){
		if(sig[i]>max){
			max = sig[i];
			maxi = i;
		}
	}
	return maxi;
}

int isAnn(int *sig, long sigLen, long start, long len){
	int i;
	for(i=start; i<len && i<sigLen; i++)
		if(sig[i]>0)
			return sig[i];
	return 0;
}

void writeQRS(char *record, int chan, char *ann) { // Anotacije zapise v datoteko
	WFDB_Anninfo annIFO;
	WFDB_Annotation annot;
	int i;

	annIFO.name = ann;
	annIFO.stat = WFDB_WRITE;
	if (annopen(record, &annIFO, 1) < 0) {
		fprintf(stderr, "Error opening QRS file\n");
		return;
	}

	annot.subtyp = annot.chan = annot.num = 0;
	annot.aux = NULL;

	for (i = 0; i < samples; i++) {
		if (finalann[i] != 0){
			annot.anntyp = finalann[i];
			annot.time = i;
			if (putann(0, &annot) < 0) {
				break;
			}
		}
	}
}

int main(int argc, char *argv[]) {
	long i;
	char *record = NULL;
	char *annotator = NULL;
	double thresh;

	for (i = 1; i < argc; i++) { // Pobere ven vrednosti stikal -r, -a, -n
		if (argv[i][0] != '-') {
			fprintf(stderr, "Error parsing command line\n");
			exit(1);
		}
		switch (argv[i][1]) {
			case 'r':
				i++;
				record = (char*) malloc(sizeof(char) * (strlen(argv[i]) + 2));
				strcpy(record, argv[i]);
				break;
			case 'a': 
				i++;
				annotator = (char*) malloc(sizeof(char) * (strlen(argv[i]) + 2));
				strcpy(annotator, argv[i]);
				break;
			case 'n': 
				i++;
				normCnst = atof(argv[i]);
				break;
			default:
				fprintf(stderr,"Wrong switch\n");
				exit(2);
		}
	}

	if (record == NULL) {
		fprintf(stderr, "No record was specified, exiting\n");
		exit(2);
	}

	if ((openLeads = openRecord(record)) < 1) { // Odpre datoteko za branje 3 signalov
		fprintf(stderr, "Error opening record, exiting 3\n");
		exit(3);
	}

	nrSamps = s->nsamp; // Dobi ven stevilo samplov

	fprintf(stderr,"nrSamps %ld\n", nrSamps);

	sig0 = (double*) malloc(sizeof(double) * nrSamps);
	sig1 = (double*) malloc(sizeof(double) * nrSamps);
	sig2 = (double*) malloc(sizeof(double) * nrSamps);
	bpann = (int*) malloc(sizeof(int) * nrSamps);
	annqrs = (int*) malloc(sizeof(int) * nrSamps);
	finalann = (int*) malloc(sizeof(int) * nrSamps);

	bp0 = (double*) malloc(sizeof(double) * nrSamps);

	if ((samples = ReadBuffer(0)) <= 0) { // Prebere 1. komponento datoteke signalov v seznam sig0 in vrne stevilo prestetih samplov
		fprintf(stderr, "Error opening record, exiting 333\n");
		exit (3);
	}

	if (samples != nrSamps) { // Stevilo prebranih samplov se razlikuje od stevila prestetih oz prebranih samplov
		fprintf(stderr,"Sample count differs\n");
	}

	detectQRS();

	if (annotator == NULL) {
		annotator = (char*) malloc(sizeof(char) * 5);
		sprintf(annotator, "qrsm");
	}

	writeQRS(record, 4, annotator);

	wfdbquit();
	free(sig0);
	free(sig1);
	free(sig2);
	free(bpann);
	free(annqrs);
	free(finalann);
	free(bp0);
	free(annotator);
	return 0;
}
