function challenge(recordName)
% phase III: entry code 
%
% %Example using training data- 
% challenge('100')
%

%This line is required in order to properly load the WFDB Toolbox
%in the Octave testing framework
[~,config]=wfdbloadlib;
if(config.inOctave)
crash_dumps_octave_core(0);
end



%------------------------------------------------

annName = 'qrs'; % This annotator name is required by the Challenge rules.

% The Toolbox's wfdbdesc function reads metadata for the record, including
% the names of the signals.
siginfo = wfdbdesc(recordName);
description = squeeze(struct2cell(siginfo));
description = description(5,:);
% For more information, run 'help wfdbdesc'.

% Using the helper function defined below, find the ECG and blood pressure
% signals available in the record.
ecg_ind = get_index(description,'ECG');
abp_ind = get_index(description,'BP');
ppg1_ind= get_index(description,'PLETH');
ppg2_ind= get_index(description,'PPG');
if ~isempty(ppg1_ind)
    ppg_ind=ppg1_ind;
else
    ppg_ind=ppg2_ind;
end;

%% LOAD ECG
% Using the Toolbox's gqrs function, annotate the first ECG signal to generate
% an annotation file (recordName.qrs), using default values for gqrs's N, N0,
% and threshold parameters.
N = [];
N0 = [];
threshold = [];
gqrs(recordName,N,N0,ecg_ind(1),threshold,annName);

% load gqrs annotation
% [ann_ecg0,type_ecg,subtype,chan,num] = rdann(recordName,'qrs');
% load ecg signal
[tm,sig_ecg0,fs_ecg0]=rdsamp(recordName,ecg_ind(1));
if fs_ecg0~=250
    sig_ecg=resample(sig_ecg0,250,fs_ecg0);
%     ann_ecg=round(ann_ecg0*250/fs_ecg0);
else
    sig_ecg=sig_ecg0;
%     ann_ecg=ann_ecg0;
end;


%% BP is available
if (~isempty(abp_ind)) 
%     wabp(recordName);
    %load wabp annotation
%     [ann_bp0,type_bp,subtype,chan,num] = rdann(recordName,'wabp');
    %load bp signal
    [tm,sig_bp0,fs_bp0]=rdsamp(recordName,abp_ind(1));
    if fs_bp0~=250
        sig_bp=resample(sig_bp0,250,fs_bp0);
%         ann_bp=round(ann_bp0*250/fs_bp0);
    else
        sig_bp=sig_bp0;
%         ann_bp=ann_bp0;
    end;
    
%     ann_fuse=challenge_i2r(sig_ecg,ann_ecg,sig_bp,ann_bp,1);%1 for abp
    [ann_fuse,num_beat_label]=get_beat_ecg_mode2(sig_ecg,sig_bp,250,0.3);
    
    if fs_ecg0~=250
        ann_fuse0=round(ann_fuse*fs_ecg0/250);
    else
        ann_fuse0=ann_fuse;
    end
    wrann(recordName,annName,ann_fuse0);%,[],[],[],[]);

elseif (~isempty(ppg_ind)) %PPG available
    %load ppg signal
    [tm,sig_ppg0,fs_ppg0]=rdsamp(recordName,ppg_ind(1));
    if fs_ppg0~=250
        sig_ppg=resample(sig_ppg0,250,fs_ppg0);
    else
        sig_ppg=sig_ppg0;
    end;
    
%     ann_fuse=challenge_i2r(sig_ecg,ann_ecg,sig_ppg,ann_ecg,2);%2 for ppg
    [ann_fuse,num_beat_label]=get_beat_ecg_mode2(sig_ecg,sig_ppg,250,0.6);
    
    if fs_ecg0~=250
        ann_fuse0=round(ann_fuse*fs_ecg0/250);
    else
        ann_fuse0=ann_fuse;
    end
    wrann(recordName,annName,ann_fuse0);%,[],[],[],[]);

else
    
    %handle ecg alone case
    
%     ann_fuse=challenge_i2r_ecgonly(sig_ecg,ann_ecg);
%     
%     if fs_ecg0~=250
%         ann_fuse0=round(ann_fuse*fs_ecg0/250);
%     else
%         ann_fuse0=ann_fuse;
%     end
%     wrann(recordName,annName,ann_fuse0);%,[],[],[],[]);
    
    
end;


%------------------------------------------------



%%%%%%%%%%%% Helper Function %%%%%%%%%%%%%%%%%%%%%
function ind=get_index(description,pattern)
M=length(description);
tmp_ind=strfind(description,pattern);
ind=[];
for m=1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1)=m;
    end
end




