function [ rp ] = yeh( ECG, orig_Fs)
% Offline QRS detection based on paper from Yeh & Wang
%   ECG: input ECG signal
%   Fs= sampling frequency

%% Preproces
ECG=double(ECG);
ind=find(isnan(ECG));
for i=1:length(ind)
    ECG(ind(i))=ECG(ind(i)-1);
end;
if orig_Fs~=250
    ECG=resample(ECG,250,orig_Fs);
end;
Fs=250;
len=size(ECG,1);
window=floor(50/360*Fs);
theta=2*pi*60/Fs;
r=0.95;
b=[1 -2*cos(theta) 1];
a=[1 -2*r*cos(theta) r^2];
[bb,aa]=butter(6,70/125,'low');
[bbb,aaa]=butter(2,0.05/125,'high');
[b4,a4]=butter(6,100/125,'low');
f_tel=conv(b,conv(bb,bbb));
f_noem=conv(a,conv(aa,aaa));
xd=diff(filtfilt(f_tel,f_noem,double(ECG)));
xd=[xd(1);xd];
xd=filtfilt(b4,a4,xd);
xpos=xd;
xneg=xd;
xpos(xpos<3*mean(xpos(xpos>0)))=0;
xneg(xneg>3*mean(xneg(xneg<0)))=0;

%% R peak detection
pp=[];
inds=find(xpos>0);
for i=1:length(inds)
    if i~=1
        if inds(i)~=inds(i-1)+1
            [p,j]=max(xpos(begin:inds(i-1)));
            pp(end+1,1)=begin-1+j(1);
            pp(end,2)=p(1);
            begin=inds(i);
        end;
    else
        begin=inds(1);
    end;
end;

torem=[];
for i=1:size(pp,1)
    if isempty(find(xneg(max(1,pp(i)-window):min(len,pp(i)+window))<0,1))
        torem=[torem i];
    end;
end;
pp(torem,:)=[];

while 1
    if pp(2,1)-pp(1,1)<0.2*Fs
        if pp(2,2)>pp(1,2)
            pp(1,:)=[];
        else
            pp(2,:)=[];
        end;
    else
        break;
    end;
end;
while 1
    if pp(3,1)-pp(2,1)<0.2*Fs
        if pp(3,2)>pp(2,2)
            pp(2,:)=[];
        else
            pp(3,:)=[];
        end;
    else
        break;
    end;
end;
rp(1:3,:)=pp(1:3,:);
for i=4:size(pp,1)
    if pp(i,2)>mean(rp(end-2:end,2))/1.5
        if pp(i,1)-rp(end,1)>0.2*Fs
            rp(end+1,:)=pp(i,:);
        elseif rp(end,2)<pp(i,2)
            rp(end,:)=pp(i,:);
        end;
    end;
    if pp(i,1)-rp(end,1)>1.66*(rp(end,1)-rp(end-1,1))
        [val,ind]=max(xpos(rp(end,1)+round(0.2*Fs):pp(i,1)));
        if ~isempty(ind) && val>0
            rp(end+1,1)=ind(1)+rp(end,1)+round(0.2*Fs)-1;
            rp(end,2)=val;
        end;
    end;
end;
rp=rp(:,1)';

%% Postprocess
wt=round(0.05*Fs);
for i=1:length(rp)
    [~,ind]=max(ECG(max(1,rp(i)-wt):min(len,(rp(i)+wt))));
    if 1>round(rp(i)-wt)
        rp(i)=ind;
    else
        rp(i)=rp(i)-wt+ind;
    end;
end;

if orig_Fs~=250
    rp=round(rp*orig_Fs/Fs);
end;