function [nECG] = flat_ECG(ecg,fs,envel);

sze = length(ecg);
time = [1 : sze]/fs;

% Using the envelopes. top minus bottom
if isempty(envel)
    envel = 0.100/(1/fs);
end

envt = env_secant(time,ecg, envel, 'top');
envb = env_secant(time,ecg, envel, 'bottom');
nECG = envt-envb;

% plot(ecg),hold on,plot(nECG,'r')