function [ output ] = envel(signal,Fs,window)
%Create maximal envelope of signal using exponential decreasing function
%   signal: input signal
%   Fs: sampling frequency
%   window: window in seconds in which envelope is created

    window=round(window*Fs);
    output=signal;
    for i=window:length(signal)
        output(i)=max(fliplr(signal(i-window+1:i)').*exp(-1*((1:window)/Fs)));
    end;
end