function challenge(recordName)

[~,config] = wfdbloadlib;
if(config.inOctave)
    crash_dumps_octave_core(0);
end
annName = 'qrs'; 

siginfo = wfdbdesc(recordName);
description = squeeze(struct2cell(siginfo));
description = description(5,:);

[tm,signal,Fs]=rdsamp(recordName);
if isempty(Fs)
    Fs=round(length(tm)/tm(end));
end;

mpd=round(0.2*Fs);

ecg_ind = unique([1 get_index(description,'ECG')]);
per_ind = unique([get_index(description,'BP') get_index(description,'ABP') get_index(description,'PPG') ...
    get_index(description,'PLETH') get_index(description,'ART') get_index(description,'PAP') get_index(description,'pressure')]);
dim=length(ecg_ind)+length(per_ind);
N=size(signal,1);

if length(ecg_ind)+length(per_ind)>2
    if length(per_ind)>1
        per_ind=per_ind(1);
    end;
    if length(ecg_ind)>1 && ~isempty(per_ind)
        ecg_ind=ecg_ind(1);
    end;
end;

%% learn delays
% Do peak detection for all signals
rp=cell(1,length(ecg_ind)+length(per_ind));
for i=1:length(ecg_ind)
    gqrs(recordName,[],[],ecg_ind(i),[],annName);
    try
        rp{i}=rdann(recordName,annName)'+round(0.03*Fs);
    catch
        rp{i}=[];
    end;
end;
for i=1:length(per_ind)
    rp{length(ecg_ind)+i}=PeriodicPeakDetection(signal(:,per_ind(i)),Fs);
end;

mincom=Inf;
fac=1;
cr=[];
choice=0;
for i=1:length(ecg_ind)
    if length(rp{i})>2
        if var(diff(60*Fs./diff(rp{i})))/var(60*Fs./diff(rp{i}))<mincom
            cr=rp{i};
            mincom=var(diff(60*Fs./diff(rp{i})))/var(60*Fs./diff(rp{i}));
            fac=i;
        end;
    end;
end;
if length(rp{fac})*Fs*60/size(signal,1)<30 || length(rp{fac})*Fs*60/size(signal,1)>150
for i=1:length(per_ind)
    if length(rp{i+length(ecg_ind)})>2
        if choice==0
            if var(diff(60*Fs./diff(rp{i+length(ecg_ind)})))/var(60*Fs./diff(rp{i+length(ecg_ind)}))<mincom*0.8
                choice=1;
                mincom=var(diff(60*Fs./diff(rp{i+length(ecg_ind)})))/var(60*Fs./diff(rp{i+length(ecg_ind)}));
                fac=i+length(ecg_ind);
            end;
        else
            if var(diff(60*Fs./diff(rp{i+length(ecg_ind)})))/var(60*Fs./diff(rp{i+length(ecg_ind)}))<mincom
                mincom=var(diff(60*Fs./diff(rp{i+length(ecg_ind)})))/var(60*Fs./diff(rp{i+length(ecg_ind)}));
                fac=i+length(ecg_ind);
            end;
        end;
    end;
end;
end;
    
if choice==1
    if ismember(per_ind(fac-length(ecg_ind)),get_index(description,'PAP'))
        cr=rp{fac}-round(0.20*Fs);
    else
        cr=rp{fac}-round(0.25*Fs);
    end;
else
    cr=rp{fac};
end;

%% Choose reference signal and synchronize
if length(cr)>1
    ecgtoremove=[];
    peaks=zeros(size(signal,1),dim);
    for i=1:length(ecg_ind)
        dists=[];
        if i~=fac && ~isempty(rp{i})
            realpeaks=rp{i};
            for j=2:length(cr)-1
                f1=find(realpeaks-cr(j)>-0.1*Fs & abs(realpeaks-cr(j))<cr(j)-cr(j-1) & abs(realpeaks-cr(j))<Fs);
                [dis,ff1]=min(abs(cr(j)-realpeaks(f1)));
                if ~isempty(ff1)
                    if cr(j)<realpeaks(f1(ff1))
                        dists(end+1)=dis;
                    else
                        dists(end+1)=-dis;
                    end;
                end;
            end;
            [N1,pos]=hist(dists,-round(0.1*Fs):1:round(1.5*Fs));
            [~,ind]=max(N1);
            del=pos(ind);
            realpeaks=realpeaks-del;
            rp{i}=realpeaks;
        elseif i==fac
            realpeaks=cr;
        end
        if (i~=fac && std(dists)>0.15*Fs) || isempty(rp{i})
            ecgtoremove=[ecgtoremove i];
        else
            for counter=-round(0.01*Fs):round(0.01*Fs)
                peaks(realpeaks(realpeaks>abs(counter) & realpeaks<N-counter)+counter,i)=1;
            end;
        end;
    end;
    
    pertoremove=[];
    for i=1:length(per_ind)
        if i+length(ecg_ind)~=fac && ~isempty(rp{i+length(ecg_ind)})
            annot=rp{length(ecg_ind)+i};
            dists=[];
            for j=2:length(cr)-1
                f1=find(annot-cr(j)>-0.1*Fs & abs(annot-cr(j))<cr(j)-cr(j-1) & abs(annot-cr(j))<Fs);
                [dis,ff1]=min(abs(cr(j)-annot(f1)));
                if ~isempty(ff1)
                    if cr(j)<annot(f1(ff1))
                        dists(end+1)=dis;
                    else
                        dists(end+1)=-dis;
                    end;
                end;
            end;
            [N1,pos]=hist(dists,-round(0.1*Fs):1:round(1.5*Fs));
            [~,ind]=max(N1);
            del=pos(ind);
            if sum(N1(max(1,ind-round(0.05*Fs)):ind+round(0.05*Fs)))/length(dists)>0.7 && length(dists)>10
                annot=annot-del;
                rp{i+length(ecg_ind)}=annot;
                if annot(1)<-round(0.02*Fs)
                    annot(1)=[];
                elseif annot(1)<1
                    annot(1)=1;
                end;
                for counter=-round(0.05*Fs):round(0.05*Fs)
                    peaks(annot(annot>abs(counter) & annot<N-counter)+counter,i+length(ecg_ind))=1;
                end;
            else
                pertoremove=[pertoremove i];
            end;
        elseif i+length(ecg_ind)==fac
            annot=cr;
            for counter=-round(0.05*Fs):round(0.05*Fs)
                peaks(annot(annot>abs(counter) & annot<N-counter)+counter,i+length(ecg_ind))=1;
            end;
        else
            pertoremove=[pertoremove i];
        end;
    end;
    per_ind(pertoremove) = [];
    peaks(:,pertoremove+length(ecg_ind)) = [];
      ecg_ind(ecgtoremove) = [];
    peaks(:,ecgtoremove) = [];
    dim = length(ecg_ind)+length(per_ind);
    
    %% find which are correct combo's
    realpeaks=[]; temp=floor(dim/2)+1;
    while isempty(realpeaks) && temp>0
        realpeaks=findPeak3(sum(peaks,2),peaks,max(1,temp),Fs,2);
        temp=temp-1;
    end;
    
    %% correct begin and end of signal
    einds=cell(dim);
    binds=cell(dim);
    e=zeros(1,dim);
    b=zeros(1,dim);
    for i=1:dim
        s=rp{i};
        einds{i}=s(s>realpeaks(end)+mpd);
        if length(einds{i})<(((N-realpeaks(end))/Fs)/(60/50))-1
            e(i)=Inf;
        else
            if ~isempty(einds{i})
                goodE=[realpeaks(max(1,end-3):end) einds{i}];
                if length(goodE)>2
                    e(i)=var(diff(goodE));
                else
                    e(i)=Inf;
                end;
            else
                goodE=[realpeaks(max(1,end-3):end) N+round(0.5*Fs)];
                if length(goodE)>2
                    e(i)=var(diff(goodE));
                else
                    e(i)=Inf;
                end;
            end;
        end;
        binds{i}=s(s<realpeaks(1)-mpd);
        if length(binds{i})<((realpeaks(1)/Fs)/(60/50))-1
            b(i)=Inf;
        else
            if ~isempty(binds{i})
                temp1=binds{i};
                if temp1(1)>2*Fs
                    b(i)=Inf;
                else
                    goodE=[binds{i} realpeaks(1:min(length(realpeaks),3))];
                    if length(goodE)>2
                        b(i)=var(diff(goodE));
                    else
                        b(i)=Inf;
                    end;
                end;
            else
                goodE=[-round(0.1*Fs) realpeaks(1:min(length(realpeaks),3))];
                if length(goodE)>2
                    b(i)=var(diff(goodE));
                else
                    b(i)=Inf;
                end;
            end;
        end;
    end;
    goodE=[-round(0.3*Fs) realpeaks(1:min(length(realpeaks),3))];
    if length(goodE)>2
        ref=var(diff(goodE));
    else
        ref=Inf;
    end;
    if ref>min(b)
        [~,i]=min(b);
        realpeaks=[binds{i} realpeaks];
    end;
    goodE=[realpeaks(max(1,end-3):end) N+round(0.3*Fs)];
    if length(goodE)>2
        ref=(var(diff(goodE)));
    else
        ref=Inf;
    end;
    if ref>min(e)
        [~,i]=min(e);
        realpeaks=[realpeaks einds{i}];
    end;
    
    %% rest of signal
    if length(realpeaks)>1
        if realpeaks(2)-realpeaks(1)>1.5*Fs
            [realpeaks]=FindBestMatch1(realpeaks, peaks, Fs);
        end;
        
        count=3;
        while count<=length(realpeaks)
            if realpeaks(count)-realpeaks(count-1)>1.5*median(diff(realpeaks(max(count-4,1):count-1))) && realpeaks(count)-realpeaks(count-1)>0.4*Fs
                if max(sum(peaks(realpeaks(count-1)+mpd:realpeaks(count)-mpd,:),2))>=dim/4
                    [realpeaks,added]=FindBestMatch2(realpeaks, count, peaks, Fs);
                    if added==0
                        count=count+1;
                    end;
                else
                    count=count+1;
                end;
            else
                count=count+1;
            end;
        end;
        i=3;
        while i<length(realpeaks)
            if realpeaks(i)-realpeaks(i-1)<0.2*Fs
                if realpeaks(i-1)-realpeaks(i-2)>realpeaks(i+1)-realpeaks(i)
                    realpeaks(i)=[];
                else
                    realpeaks(i-1)=[];
                end;
            else
                i=i+1;
            end;
        end
    elseif ~isempty(per_ind)
        realpeaks=annot;
    else
        return;
    end;
elseif ~isempty(per_ind)
    realpeaks=PeriodicPeakDetection(signal(:,per_ind(1)),Fs);
    realpeaks=realpeaks-round(0.27*Fs);
else
    return;
end;

wrann(recordName,annName,realpeaks');
function ind = get_index(description,pattern)
M = length(description);
tmp_ind = regexpi(description,pattern);
ind = [];
for m = 1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1) = m;
    end
end