function [ annotations] = PeriodicPeakDetection(signal,orig_Fs)
%PeriodicPeakDetection Peak detection in (quasi-)periodic signal
%   signal: signal for analysis
%   Fs: used sampling frequency in signal
if orig_Fs<250
    Fs=orig_Fs;
else
    Fs=orig_Fs/2;
    signal=signal(2:2:end);
end;
signal=envel(signal,Fs,1);
N=length(signal);
signal=detrend(signal);
step=floor(0.3*Fs);
annotations=zeros(1,ceil(N/step));
vals=zeros(1,ceil(N/step));
[vals(1),annotations(1)]=max(signal(1:step));
j=2;
for i=2*step:step:N
    [val,ind]=max(signal(i-step+1:i));
    ind=ind(1)+i-step;
    if ind-annotations(j-1)>step
        annotations(j)=ind;
        vals(j)=val(1);
    elseif vals(j-1)<val(1)
        annotations(j-1)=0;
        vals(j-1)=0;
        annotations(j)=ind;
        vals(j)=val(1);
    end;
    j=j+1;
end;

if i~=N
    [val,ind]=max(signal(i+1:N));
    ind=ind(1)+i;
    if ind-annotations(end-1)>step
        annotations(end)=ind;
        vals(end)=val(1);
    elseif vals(end-1)<val(1)
        annotations(end-1)=0;
        vals(end-1)=0;
        annotations(end)=ind;
        vals(end)=val(1);
    end;
end;

annotations=annotations(annotations~=0);

for i=1:length(annotations)
    temp=max(signal(max(1,annotations(i)-step+1):min(annotations(i)+step-1,N)));
    if temp(1)~=signal(annotations(i))
        annotations(i)=0;
    end;
end;

annotations=annotations(annotations~=0);

if Fs~=orig_Fs
    annotations=annotations*2;
end;

end