function [ output ] = NoiseFinder( signal, len, Fs)
%UNTITLED2 Summary of this function goes here
%   signal: ECG to analyse
%   len: Length of segment in seconds
%   Fs: sample frequency
ind=find(isnan(signal));
for i=1:length(ind)
    signal(ind(i))=signal(ind(i)-1);
end;

len=round(len*Fs);
[fb,fa]=butter(4,[1,40]*2/Fs);
signal=flipud(filter(fb,fa,flipud(filter(fb,fa,signal))));
N=length(signal);

%compute autocorrelation functions
k=ceil(length(signal)/len);
A=zeros(ceil(length(signal)/len),1+(len)-2);
for i=1:k
    seg=signal(min(len*i-len+1,N-len+1):min(len*i,N));
    n =  2^(nextpow2(length(seg)) + 1);
    four    =  fft(seg-mean(seg) , n);
    ACF  =  ifft(four .* conj(four));
    ACF  =  ACF(1:(len-2 + 1))./ACF(1); 
    A(i,:) =  real(ACF);
end;

% construction similarity matrix
S=zeros(k,k);
for i=1:k
    for j=i:k
        S(i,j)=sum(A(i,:).*A(j,:))/(norm(A(i,:))*norm(A(j,:)));
        S(j,i)=S(i,j);
    end;
end;

%calculate weigths for each column
M=sum(S);

%return best period
l=min(max(floor(k/10),3),round(60*Fs/len));
maxtemp=0; a=0;
for i=l:k
    temp=sum(M(i-l+1:i));
    if temp>maxtemp
        a=i;
        maxtemp=temp;
    end;
end;

output=[(a-l)*len+1,a*len];

end