function [ good,added] = FindBestMatch2(peaks,n,x,Fs)
%   Find labels from 1 signal that fit best in RR(n)
%   peaks: list of labels
%   n: index of RR(n) in which labels should be found
%   x: see paper
%   Fs: sampling frequency
%   good: new updated list of peaks
%   added: indicates whether labels are added (1) or not (0)

added=0;
mpd=round(0.2*Fs);
good=peaks;
dis=(peaks(n)-peaks(n-1));
estval=dis/(median(diff(peaks(max(n-4,1):n-1))));
S=size(x,2);
if estval<2.6 && estval>1.4
    est=1;
elseif estval<3.5
    est=2;
else
    est=round(estval)-1;
end;
inds=cell(S,1);
for i=1:S
    inds{i}=findPeak3(x(peaks(n-1)+mpd:peaks(n)-mpd,i),x,0.8,Fs,0)+peaks(n-1)-1+mpd;
end;
sizes=zeros(S,1);
for i=1:S
    sizes(i)=size(inds{i},2);
end;

if est<6 && est~=0
    ind=find(sizes==est);
    if length(ind)==1 % only 1 with good estimated number
        good=[peaks inds{ind}];
        good=sort(good);
        added=1;
    elseif ~isempty(ind) %multiple with good estimated number
        estVector=floor(peaks(n-1)+floor(dis/(est+1))):floor(dis/(est+1)):ceil(peaks(n)-ceil(dis/(est+1)));
        dists=zeros(1,length(ind));
        for i=1:length(ind)
            dists(i)=norm(inds{ind(i)}-estVector);
        end;
        [~,i]=min(dists);
        good=[peaks inds{ind(i)}];
        good=sort(good);
        added=1;
    else %none with estimated number
        if any(sizes==0)
            for i=1:S
                    temp=[peaks(max(1,n-3):n-1) inds{i} peaks(n:min(n,length(peaks)))];
                    temp=60*Fs./diff(temp);
                    act(i)=var(temp);
            end;
            [~,i]=min(act);
            if ~isempty(inds{i})
                good=[peaks inds{i}];
                good=sort(good);
                if sizes(i)>0
                    added=1;
                end;
            end;
        else
        dists=zeros(1,S);
        for i=1:S
            est1=sizes(i);
            if abs(est-est1)<2 && est1>0
                estVector=floor(peaks(n-1)+floor(dis/(est1+1))):floor(dis/(est1+1)):ceil(peaks(n)-ceil(dis/(est1+1)));
                dists(i)=norm(inds{i}-estVector)/est1;
            elseif est1>est
                estVector=floor(peaks(n-1)+floor(dis/(est+1))):floor(dis/(est+1)):ceil(peaks(n)-ceil(dis/(est+1)));
                tempi=[];
                temp=inds{i};
                for j=1:est
                    if j>1
                        dis1=peaks(n)-tempi(end);
                        estVector=floor(tempi(end)+floor(dis1/(est+1-j+1))):floor(dis1/(est+1-j+1)):ceil(peaks(n)-ceil(dis1/(est+1-j+1)));
                    end;
                    [val,ind]=min(abs(estVector(1)-temp));
                    if val<0.15*Fs
                        tempi(end+1)=temp(ind);
                    else
                        break;
                    end;
                end;
                if length(tempi)==est
                    estVector=floor(peaks(n-1)+floor(dis/(est+1))):floor(dis/(est+1)):ceil(peaks(n)-ceil(dis/(est+1)));
                    dists(i)=norm(tempi-estVector)/est;
                else
                    dists(i)=Inf;
                end;
            else
                dists(i)=Inf;
            end;
        end;
        [val,i]=min(dists);
        if val~=Inf
            good=[peaks inds{i}];
            good=sort(good);
            added=1;
        end;
        end;
    end;
else
    act=zeros(1,S);
    if S==2 && length(inds{1})==length(inds{2})
        % typically the case if there is a shift in delays between
        % labels of both ECG/BP
        if ~isempty(inds{1})
            go=inds{1};
            go2=inds{2};
            if abs(go(1)-(peaks(n-1)+diff(peaks(max(1,n-4):n-1))))<...
                    abs(go2(1)-(peaks(n-1)+diff(peaks(max(1,n-4):n-1))))
                good=[peaks inds{1}];
            else
                good=[peaks inds{2}];
            end;
            good=sort(good);
            added=1;
        end;
    else
        for i=1:S
            if ~isempty(inds{i})
                %             temp=[peaks(max(1,n-3):n-1) inds{i} peaks(n:min(n+2,length(peaks)))];
                temp=[peaks(max(1,n-3):n-1) inds{i} peaks(n:min(n,length(peaks)))];
%                 act(i)=var(diff(temp,3))/var(diff(temp,2));
                %             act(i)=var(diff(temp,2))/var(diff(temp,1));
                act(i)=var(diff(temp));
            else
                act(i)=Inf;
            end;
        end;
        [~,i]=min(act);
        if ~isempty(inds{i})
            good=[peaks inds{i}];
            good=sort(good);
            added=1;
        end;
    end;
end;
end