function [ peaks ] = FindBestMatch1( peaks, x, Fs )
%	Find labels that belong best, specific for finding peaks between first
%	and second label
%   peaks: list of heart beat labels
%   x: see corresponding paper
%   Fs: sampling frequency

    v=zeros(1,size(x,2));
    inds=cell(1,size(x,2));
    for i=1:size(x,2)
        inds{i}=findPeak3(x(peaks(1)+round(0.2*Fs):peaks(2)-round(0.2*Fs),i),[],0.8,Fs,0)...
            +peaks(1)+round(0.2*Fs);
%         v(i)=sqrt(var(diff([peaks(1) inds{i} peaks(2)],2))/var(diff([peaks(1) inds{i} peaks(2)])));
        v(i)=sqrt(var(60*Fs./diff([peaks(1) inds{i} peaks(2)])));
    end;
    [~,ind]=min(v);
    peaks=[peaks(1) inds{ind} peaks(2:end)];
end