function challenge(recordName)
% Best regards & Thanks !
% Xuejian Li & Qiuwen Lu
% Mobile :+86 15201689153
% Email:2013200718@grad.buct.edu.cn
% 2013 postgraduate of Control Science and Control Engineering
% Information Science and Technology College
% Beijing University of Chemical Technology
% 15 beisanhuan east road, chaoyang district, beijing, 100029
[~,config] = wfdbloadlib;
annName = 'qrs'; 
siginfo = wfdbdesc(recordName);
description = squeeze(struct2cell(siginfo));
description = description(5,:);
ecg_ind = get_index(description,'ECG');
bp_ind = get_index(description,'BP');
N = [];
N0 = [];
threshold = [];
gqrs(recordName,N,N0,ecg_ind(1),threshold,annName);  
if (~isempty(bp_ind)) 
   [rr_ecg,~] = ann2rr(recordName,'qrs');
   mean_ecg=mean(rr_ecg);
   std_ecg=std(rr_ecg);
   [sam_ecg,~,~,~,~] = rdann(recordName,annName);
   len_ecg=length(sam_ecg);
 
   wabp(recordName);
   [rr_abp,~] = ann2rr(recordName,'wabp');
   mean_abp=mean(rr_abp);
   std_abp=std(rr_abp);
   [sam_abp,~,~,~,~] = rdann(recordName,'wabp');
   len_abp=length(sam_abp);
   mean_all=(mean_ecg+ mean_abp)/2;
   
   Sam=[];
   snum=1;
   Sam(snum)=sam_ecg(1);

   flag=1;
   flag_ecg=2;
   flag_abp=2;
   while(flag)
       ecgRR=sam_ecg(flag_ecg)-sam_ecg(flag_ecg-1);
       abpRR=sam_abp(flag_abp)-sam_abp(flag_abp-1);
       decg=abs(ecgRR-mean_all)*std_ecg;
       dabp=abs(abpRR-mean_all)*std_abp;
       dall=decg+dabp;
       RR=decg/dall*abpRR+dabp/dall*ecgRR;  
       FLAG_ecg=sam_ecg(flag_ecg-1)+RR;
       FLAG_abp=sam_abp(flag_abp-1)+RR;
  
       min_ecg=abs(FLAG_ecg-sam_ecg(flag_ecg));
       f1=1;
       x1=flag_ecg+1;
       while(f1) 
            dx1=abs(FLAG_ecg-sam_ecg(x1));
            if(dx1>min_ecg)
               f1=0;
            else
               min_ecg=dx1;
               flag_ecg=x1; 
               x1=x1+1; 
            end
       end
       snum=snum+1;
       Sam(snum)=sam_ecg(flag_ecg);
       flag_ecg=x1;
       
       min_abp=abs(FLAG_abp-sam_abp(flag_abp));
       f2=1;
       x2=flag_abp+1;
       while(f2)
           dx2=abs(FLAG_abp-sam_abp(x2));
           if(dx2>min_abp)
               f2=0;
           else
               min_abp=dx2;
               flag_abp=x2; 
               x2=x2+1; 
           end      
       end
       flag_abp=x2;   
       if(flag_ecg>=len_ecg || flag_abp>=len_abp)
          flag=0; 
       end
   end
   if(flag_ecg<=len_ecg)
      Sam=[Sam,sam_ecg(flag_ecg:end)'];
   end
   snum=length(Sam);
   type=char(78*ones(snum,1));% N
   subtype=char(0*ones(snum,1));% char(0)
   chan=zeros(snum,1);
   num=ones(snum,1);
   wrann(recordName,annName,Sam',type,subtype,chan,num);

   filename=[recordName,'_ecg.txt'];
   bxb(recordName,'atr','qrs',filename);
end

function ind = get_index(description,pattern)
M = length(description);
tmp_ind = strfind(description,pattern);
ind = [];
for m = 1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1) = m;
    end
end
