function challenge(recordName)

%This line is required in order to properly load the WFDB Toolbox
%in the Octave testing framework
[~,config]=wfdbloadlib;

%Compute GQRS
N=[];
N0=[];
threshold=[];
gqrs(recordName,N,N0,1,threshold,'tmp');

%Used for discarding annotations that dont have a minimum number of beats
annName='qrs'; %All competitors are expected to save their annotation as *.qrs

%Get channel infos
siginfo=wfdbdesc(recordName);
siginfo=squeeze(struct2cell(siginfo));
chan_fs = cellfun(@(x)str2double(x(1:end-3)), siginfo(6,:), 'uniformoutput', false);

description=siginfo(5,:);
signal_sel = strncmpi(description, 'BP',2);
signal_sel = signal_sel + strncmpi(description, 'ABP',3);
signal_sel = signal_sel + strncmpi(description, 'ART',3);
signal_sel = signal_sel + strncmpi(description, 'PRES',4);
indx = find(signal_sel>0,1,'first');

% signal_sel = strfind(description, 'BP');
% signal_sel = signal_sel + strfind(description, 'ABP');
% signal_sel = signal_sel + strfind(description, 'ART');
% signal_sel = signal_sel + strfind(description, 'res');
% indx = find(signal_sel>0,1,'first');

did_wabp = 0;
wabp_worked = 0;

if(~isempty(indx))
    wabp(recordName,[],[],[],indx);
    did_wabp = 1;
else
    signal_sel = strncmpi(description, 'PLETH', 5);
    signal_sel = signal_sel + strncmpi(description, 'PPG', 3);
    indx = find(signal_sel>0,1,'first');
    if(~isempty(indx))
        wabp(recordName,[],[],[],indx);
        did_wabp = 1;
    else
        signal_sel = strncmpi(description, 'SV',2);
        indx = find(signal_sel>0,1,'first');
        if(~isempty(indx))
            wabp(recordName,[],[],[],indx);
            did_wabp = 1;
        else
            indx = [];
        end
    end
end
    
[~,signal]=rdsamp(recordName,[1 indx]);

% Resample each signal to 100 Hz
fs = 100;
signal = resample(signal, fs, chan_fs{1});
signal = diff(signal);

%Filter with [0.5 30] Hz band-pass
[b,a] = butter(2,[1 30]/(fs/2));
signal = filtfilt(b, a, signal);

%Apply zscore to each channel
signal = zscore(signal);

%Define interval search window
win = 0.3*fs:1.7*fs;

%Allocate matrix for interval estimates and quality indicators
%intervals = zeros(size(signal,1), 1);

%Compute intervals
% disp(['Before int.' num2str(toc)]);
hopsize = 8;
[interv, ~] = interval_estimator_c(signal, win(1), win(end), hopsize, 0.5*fs);
% disp(['After int.' num2str(toc)]);

intervals = [zeros(20,1);interv;zeros(20,1)];
intervals = medfilt1(intervals,3);

mean_interval = round(mean(intervals(intervals~=0))/2);

%disp(['Before ann2rr' num2str(toc)]);

try
    [RR,ann]=ann2rr(recordName,'tmp');
catch
    if ~isempty(indx)
        try
            [RR,ann]=ann2rr(recordName,'wabp');
            ann=ann-chan_fs{1}*0.15;
        catch
            gqrs(recordName,N,N0,1,.25,'tmp');
            try
                [RR,ann]=ann2rr(recordName,'tmp');
            catch
                return
            end            
        end                        
    else
        gqrs(recordName,N,N0,1,.25,'tmp');
        try
            [RR,ann]=ann2rr(recordName,'tmp');
        catch
            return
        end
    end
end
    
ann(end+1)=ann(end)+RR(end);
ann=ann+1;
ann = round(ann./chan_fs{1}*fs);
ann_ecg = ann;

if did_wabp
    RR_wabp = 0;
    ann_wabp = 0;
    try
        [RR_wabp,ann_wabp]=ann2rr(recordName,'wabp');        
    end

    mean_RR_wabp      = mean(RR_wabp);
    mean_RR           = mean(RR);
    mean_interval_est = mean_interval / fs * 2 * chan_fs{1};
    
%     mean(abs(RR_wabp-mean_interval_est))/size(RR_wabp,1)
%     mean(abs(RR-mean_interval_est))/size(RR,1)    
%     
%     RR_abp_fs = RR_wabp / chan_fs{1} * fs;
%     RR_ecg_fs = RR / chan_fs{1} * fs;
%     pos_abp = round((ann_wabp / chan_fs{1} * fs + 0.5 * RR_abp_fs)/hopsize);
%     pos_ecg = round((ann_ecg(1:end-1) + 0.5 * RR_ecg_fs)/hopsize);
%     
%     mean(abs(RR_abp_fs-intervals(pos_abp)))
%     mean(abs(RR_ecg_fs-intervals(pos_ecg)))
    
    
%    if(abs(mean_RR_wabp - (mean_interval / fs * 2 * chan_fs{1})))<(abs(mean_RR - (mean_interval / fs * 2 * chan_fs{1})))
%    if(var(RR_wabp)<var(RR))&&(size(RR_wabp,1)>.5*size(RR,1))&&(mean_RR_wabp > (1.8 * mean_interval / fs * 2 * chan_fs{1}))&&(mean_RR_wabp < (2.2 * mean_interval / fs * 2 * chan_fs{1}))
%    if(10*var(RR_wabp)<var(RR))&&(size(RR_wabp,1)>.5*size(RR,1))||(var(RR_wabp)<var(RR))&&(mean_RR_wabp > (1.9 * mean_interval / fs * chan_fs{1}))&&(mean_RR_wabp < (2.2 * mean_interval / fs * chan_fs{1}))
%    if(1.1*abs(mean_RR_wabp-mean_interval_est)<abs(mean_RR-mean_interval_est))
    ann_wabp(end+1)=ann_wabp(end)+RR_wabp(end);
    ann_wabp=ann_wabp+1-chan_fs{1}*0.15;
    ann_wabp= round(ann_wabp./chan_fs{1}*fs);

    wabp_worked = 1;
    
     if (mean(abs(RR_wabp-mean_interval_est))/size(RR_wabp,1)) < (mean(abs(RR-mean_interval_est))/size(RR,1))        
%        disp('WABP worked')        
        
                
        %%        
%         ann_wabp2 = round(ann_wabp./chan_fs{1}*fs)+1;                
%         peak_sig_ecg = zeros(size(signal,1),1);
%         peak_sig_ecg(ann) = 1;
%         peak_sig_wabp = zeros(size(signal,1),1);
%         peak_sig_wabp(ann_wabp2) = 1;
%           
%         [~, delay] = max(xcorr(peak_sig_ecg,peak_sig_wabp,101));
%         delay-101
% 
%         ann_wabp = ann_wabp + (delay-101)
%         ann_wabp(ann_wabp<1) = [];
%         ann = ann_wabp;
        %%
        ann = ann_wabp;
        ann(ann<1) = [];
    end
end

peak_sig = zeros(size(signal,1),1);
peak_sig(ann(1:2,1)) = 1;
peak_sig(ann(end-2:end,1)) = 1;

threshold = 7;

% disp(['Before second loop: ' num2str(toc)]);

ann_vec = ann;

for k=1:200

    peak_sig_old = peak_sig;
    
    peak_sig = zeros(size(signal,1),1);
    peak_sig(ann_vec(1:2,1)) = 1;
    peak_sig(ann_vec(end-2:end,1)) = 1;

    interv_qrs_l_arr = ann_vec(3:end-2)-ann_vec(2:end-3);
    interv_pos_l_arr = round((ann_vec(2:end-3)+(ann_vec(3:end-2)-ann_vec(2:end-3))/2)/hopsize);

    interv_qrs_r_arr = ann_vec(4:end-1)-ann_vec(3:end-2);
    interv_pos_r_arr = round((ann_vec(3:end-2)+(ann_vec(4:end-1)-ann_vec(3:end-2))/2)/hopsize);

    l_OK = [1;1;abs(intervals(interv_pos_l_arr)-interv_qrs_l_arr) < threshold;1;1];
    r_OK = [1;1;abs(intervals(interv_pos_r_arr)-interv_qrs_r_arr) < threshold;1;1];
    
    ann_OK = ann_vec(l_OK&r_OK);
    
    peak_sig(ann_OK) = 1;
    
    r_inser     = ann_vec(l_OK&~r_OK);
    r_inser_pos = r_inser+intervals(round((r_inser+mean_interval)/hopsize));
    r_inser_OK  = zeros(size(r_inser,1),2*threshold+1);
    
    l_inser     = ann_vec(r_OK&~l_OK);
    l_inser_pos = l_inser-intervals(round((l_inser-mean_interval)/hopsize));
    l_inser_OK  = zeros(size(l_inser,1),2*threshold+1);

    peak_sig(r_inser) = 1;
    for j=1:size(r_inser,1)
        r_inser_OK(j,:) = peak_sig(r_inser_pos(j)-threshold:r_inser_pos(j)+threshold)';
    end
    r_inser_pos = r_inser_pos(sum(r_inser_OK,2)==0);

    peak_sig(l_inser) = 1;    
    for j=1:size(l_inser,1)
        l_inser_OK(j,:) = peak_sig(l_inser_pos(j)-threshold:l_inser_pos(j)+threshold)';
    end
    l_inser_pos = l_inser_pos(sum(l_inser_OK,2)==0);
    
    peak_sig(r_inser_pos) = 1;    
    peak_sig(l_inser_pos) = 1;

    ann_vec = find(peak_sig==1);
    for j=1:2    
        double_peak = find(abs(diff(ann_vec))<2*threshold);    
        ann_vec(double_peak)   = round((ann_vec(double_peak)+ann_vec(double_peak+1))/2);
        ann_vec(double_peak+1) = [];
    end
    
    if (peak_sig==peak_sig_old)
        break;
    end
	
end

ann = ann_vec;

% disp(['After second loop: ' num2str(toc)]);
		
% Inster beat at the beginning
first_interval = intervals(round(size(win,2)*2/hopsize));
tmp_beat = round(ann(1)-first_interval);
if tmp_beat>-2*threshold
    tmp_beat = max(1,tmp_beat);
    ann = [tmp_beat;ann];
end
   
% Delete last beat
last_interv_pos = round((ann(end-1)+(ann(end)-ann(end-1))/2)/hopsize-size(win,2)/4);
last_interv_ref = intervals(last_interv_pos);
last_interv_is  = ann(end)-ann(end-1);
if last_interv_is<(last_interv_ref-4*threshold)    
    ann(end) = [];    
else % Insert last beat
    last_interv_pos = round(ann(end)/hopsize-size(win,2)/8);
    tmp_beat = ann(end) + intervals(last_interv_pos);
    if tmp_beat<size(signal,1)+threshold
        tmp_beat = min(size(signal,1),tmp_beat);
        ann = [ann;tmp_beat];
    end 
end

ann_dense      = round(ann/200);
ann_ecg_dense  = round(ann_ecg/200);
Lia            = ismember(ann_ecg_dense,ann_dense);
ann_ecg(Lia)   = [];

if did_wabp
    if wabp_worked
        ann_wabp_dense  = round(ann_wabp/200);
        Lia             = ismember(ann_wabp_dense,ann_dense);        
        ann_wabp(Lia)   = [];
        ann_wabp_dense  = round(ann_wabp/200);
        Lia             = ismember(ann_wabp_dense,ann_ecg_dense);
        ann_wabp(Lia)   = [];
        ann             = [ann;ann_wabp];
    end
end
ann        = [ann;ann_ecg];
ann        = sort(ann);
ann(ann<0) = [];

ann = round(ann/fs*chan_fs{1});
wrann(recordName,annName,ann);
%disp(['After all: ' num2str(toc)]);
%error('DONE!');
%bxb(recordName,'atr',annName,['tmp_' annName '.txt'],'0');
end