function challenge(recordName)

% BMRC Group at K.N.Toosi University of Technology, Tehran, Iran

[~,config] = wfdbloadlib;

annName = 'qrs'; % This annotator name is required by the Challenge rules.



siginfo = wfdbdesc(recordName);
description = squeeze(struct2cell(siginfo));
description = description(5,:);

ecg_ind = get_index(description,'ECG');
bp_ind = get_index(description,'BP');

N = [];
N0 = [];
threshold = [];
gqrs(recordName,N,N0,ecg_ind(1),threshold,annName);

if (~isempty(bp_ind)) 
 
   wabp(recordName);
   
   [rr_abp,~] = ann2rr(recordName,'wabp');

   [rr_ecg,~] = ann2rr(recordName,'qrs');

   [~,best] = min([var(rr_abp) var(rr_ecg)]);
   
   if(best == 1)
  
     sampfreq = siginfo(bp_ind).SamplingFrequency;
     delta_t = round(250/5);


     [sample_number,type,subtype,chan,num] = rdann(recordName,'wabp');

     sample_number = sample_number - delta_t; 


     wrann(recordName,annName,sample_number);

   end

end



%%%%%%%%%%%% Helper Function get_index %%%%%%%%%%%%%%%%%%%%%
% Inputs:
%   description  strings containing signal descriptions from wfdbdesc
%   pattern      a string to be found in the descriptions
% Output:
%   ind          indices of the descriptions that contain the pattern

function ind = get_index(description,pattern)
M = length(description);
tmp_ind = strfind(description,pattern);
ind = [];
for m = 1:M
    if(~isempty(tmp_ind{m}))
        ind(end+1) = m;
    end
end
