function [ ann, annmin ] = C2014_SVDetector(data,fs)
try
%C2014_SVDETECTOR	Detects peaks in stroke volume
%	[ ann ] = C2014_SVDetector(data,fs,alpha)
%
%
%	Inputs:
%   data            array containing channel with stroke volume
%   fs              sampling frequency [Hz]
%	Outputs:
%   ann             beat detection for stroke volume
%   annmin          ++++ dunno +++++
%
%	Example
%		[ ] = C2014_SVDetector()
%
%	See also FCN1

%	References:
%
%

%	Copyright 2014 Alistair Johnson

%	$LastChangedBy$
%	$LastChangedDate$
%	$Revision$
%	Originally written on GLNXA64 by Alistair Johnson, 20-Jun-2014 15:48:31
%	Contact: alistairewj@gmail.com

debugPlot = 0;
Num3and10 = [1.45418056200041e-06,2.96189462160366e-06,5.13872772833156e-06,8.10518807556947e-06,...
    1.19653767188767e-05,1.67950176755071e-05,2.26283700685796e-05,2.94445988738969e-05,3.71543238328210e-05,...
    4.55871912808514e-05,5.44814110732809e-05,6.34762607098984e-05,7.21085721566831e-05,7.98141760545452e-05,...
    8.59351772323643e-05,8.97337714096635e-05,9.04130853341648e-05,8.71452343223250e-05,7.91064487893309e-05,...
    6.55187350466271e-05,4.56971191338770e-05,1.91010927183451e-05,-1.46115431124291e-05,-5.55306351800420e-05,...
    -0.000103441979083430,-0.000157780774676805,-0.000217593218715924,-0.000281509271202800,-0.000347729551339882,...
    -0.000414029091156407,-0.000477780292649786,-0.000535996896948392,-0.000585400087881133,-0.000622507031254687,...
    -0.000643741216501282,-0.000645562947919167,-0.000624617263975136,-0.000577895486331637,-0.000502905561114574,...
    -0.000397845401992614,-0.000261772627369427,-9.47634507157325e-05,0.000101946921259011,0.000325850163925833,...
    0.000573084601032635,0.000838395993934886,0.00111514566818468,0.00139537114489382,0.00166990298408244,...
    0.00192853980423652,0.00216028146087574,0.00235361820456960,0.00249687136476288,0.00257857879895569,...
    0.00258791609341700,0.00251514239210925,0.00235205785614433,0.00209245820542859,0.00173257064929519,...
    0.00127145484587082,0.000711352399113927,5.79688496348248e-05,-0.000679326837000060,-0.00148739863163018,...
    -0.00234934677037526,-0.00324462640375904,-0.00414928668472672,-0.00503633179903457,-0.00587620155196136,...
    -0.00663736508379103,-0.00728701722723084,-0.00779186308433920,-0.00811897273242251,-0.00823668470852957,...
    -0.00811553420307402,-0.00772917983357719,-0.00705530156980304,-0.00607644191892277,-0.00478076290438269,...
    -0.00316269270594279,-0.00122343806070806,0.00102865838625452,0.00357793272150091,0.00640139878159551,...
    0.00946893883824969,0.0127436877410510,0.0161826065859942,0.0197372362131195,0.0233546152185980,0.0269783418841611,...
    0.0305497546610368,0.0340092017637120,0.0372973671778904,0.0403566180881739,0.0431323374750271,0.0455742054741330,...
    0.0476373940543904,0.0492836416359191,0.0504821773814226,0.0512104689621391,0.0514547724994386,0.0512104689621391,...
    0.0504821773814226,0.0492836416359191,0.0476373940543904,0.0455742054741330,0.0431323374750271,0.0403566180881739,...
    0.0372973671778904,0.0340092017637120,0.0305497546610368,0.0269783418841611,0.0233546152185980,0.0197372362131195,...
    0.0161826065859942,0.0127436877410510,0.00946893883824969,0.00640139878159551,0.00357793272150091,0.00102865838625452,...
    -0.00122343806070806,-0.00316269270594279,-0.00478076290438269,-0.00607644191892277,-0.00705530156980304,-0.00772917983357719,...
    -0.00811553420307402,-0.00823668470852957,-0.00811897273242251,-0.00779186308433920,-0.00728701722723084,-0.00663736508379103,...
    -0.00587620155196136,-0.00503633179903457,-0.00414928668472672,-0.00324462640375904,-0.00234934677037526,-0.00148739863163018,...
    -0.000679326837000060,5.79688496348248e-05,0.000711352399113927,0.00127145484587082,0.00173257064929519,0.00209245820542859,...
    0.00235205785614433,0.00251514239210925,0.00258791609341700,0.00257857879895569,0.00249687136476288,0.00235361820456960,...
    0.00216028146087574,0.00192853980423652,0.00166990298408244,0.00139537114489382,0.00111514566818468,0.000838395993934886,...
    0.000573084601032635,0.000325850163925833,0.000101946921259011,-9.47634507157325e-05,-0.000261772627369427,-0.000397845401992614,...
    -0.000502905561114574,-0.000577895486331637,-0.000624617263975136,-0.000645562947919167,-0.000643741216501282,-0.000622507031254687,...
    -0.000585400087881133,-0.000535996896948392,-0.000477780292649786,-0.000414029091156407,-0.000347729551339882,-0.000281509271202800,...
    -0.000217593218715924,-0.000157780774676805,-0.000103441979083430,-5.55306351800420e-05,-1.46115431124291e-05,1.91010927183451e-05,...
    4.56971191338770e-05,6.55187350466271e-05,7.91064487893309e-05,8.71452343223250e-05,9.04130853341648e-05,8.97337714096635e-05,...
    8.59351772323643e-05,7.98141760545452e-05,7.21085721566831e-05,6.34762607098984e-05,5.44814110732809e-05,4.55871912808514e-05,3.71543238328210e-05,...
    2.94445988738969e-05,2.26283700685796e-05,1.67950176755071e-05,1.19653767188767e-05,8.10518807556947e-06,5.13872772833156e-06,2.96189462160366e-06,1.45418056200041e-06];

%% filter
sv = data;
Num3and10resamp = resample(Num3and10,fs,250);
sv_filt = filtfilt(Num3and10resamp,1,sv);
sv = filtfilt(ones(1,20)/20,1,sv_filt);

%=== get mean trend
svmu = filtfilt(ones(1,round(2*fs))./(2*fs),1,sv);

%=== 0 crossings
svflag = sv >= svmu;
% 0 -> 1 = 1 = down to up
zc1 = find(diff(svflag) == 1);
% 1 -> 0 = -1 = up to down
zc2 = find(diff(svflag) == -1);


%=== focus on the down swing
% remove first upswing if it happens before downswing
if zc1(1) < zc2(1)
    zc1_prior = zc1(1);
    zc1(1) = [];
else
    zc1_prior = 1;
end

% % remove last upswing if it happens after downswing
if zc2(end) > zc1(end)
    % there was no final upswing - add in the final sample
    zc1 = [zc1;size(sv,1)];
end

if numel(zc1) ~= numel(zc2)
    fprintf('what how did that happen..\n');
end

% get the amplitude of the downswing

[~,annmax] = arrayfun(@(x,y) max(sv(x:y)), [zc1_prior;zc1(1:end-1)], zc2);
annmax = annmax + [zc1_prior;zc1(1:end-1)] - 1;
[~,annmin] = arrayfun(@(x,y) min(sv(x:y)), zc2, zc1);
annmin = annmin + zc2 - 1;

ann = zc2;

% % debug
% figure(1); clf; hold all;
% idx1=round(ann(2:end));
% x1 = (sv - min(sv)) ./ (max(sv) - min(sv)) - 0.5;
% svmuplot = (svmu - min(sv)) ./ (max(sv) - min(sv)) - 0.5;
% %     idx2=round(ann(2:end));
% x2 = (ann(2:end) - ann(1:end-1))./fs;
% time=(0:(1/250):(600-1/250))';
% col = linspecer(8);
% plot(time,x1,'-','Color',col(1,:));
% plot(time(idx1),x2,'x-','Color',col(2,:),'LineWidth',2,'markersize',8);
% %     plot(1:600,scaleForPlot(sqi),'x-','Color',col(2,:));
% %     plot(sqi(:,3),sqi(:,4),'x-','Color',col(3,:));
% %     plot(sqi(:,1),sqi(:,5),'o-','Color',col(4,:));
% plot(time,svmuplot,'-','color',col(3,:));
% %     plot([0,600],mean(x2)*ones(1,2) + 3*std(x2),'--','color',col(4,:));
% %     plot([0,600],mean(x2)*ones(1,2) - 3*std(x2),'--','color',col(4,:));
% plot(time(idx1),x1(idx1),'o','Color',col(7,:),'linewidth',2,'markersize',8);
% if exist('sqi_good','var')==1
%     plot(time(ann(sqi_good)), x2(sqi_good-1),'+','color',col(4,:),'markersize',14','linewidth',2);
%     x3 = ann(sqi==1); x3 =  (x3(2:end) - x3(1:end-1))./fs;
%     annx3 = ann(sqi==1); annx3 = annx3(2:end);
%     plot(time(annx3), x3,'-','color',col(4,:),'markersize',14','linewidth',2);
% end
% plot(time(idx1),x1(idx1),'o','Color',col(7,:),'linewidth',2,'markersize',8);
% keyboard;
catch
    fprintf('best catch\n');
  ann={}; annmin={};
end
end
