function filteredECG = remove_ECG_Baseline(x, FS)

%
% Remove baseline wandering from ECG data using two passes of median
% filtering
%
% Author: Alexandros Pantelopoulos
%
% 2/10/2011
%
% West Health Institute
%

% Median Filters for baseline removal (if any)
% 200ms = 96 samples (remove qrs complexes and p waves)
f1_Length = 0.2*FS;
% 600ms = 288 samples (remove t waves)
f2_Length = 0.6*FS;

% Two-pass median filtering
x2 = BaseLine1(x,f1_Length,'md');
filteredECG = BaseLine1(x2,f2_Length,'md');

