function result = acorr_norm_sq(dataVector, windowSize, startIndex)

%
% Normalized and squared Autocorrelation function
%
% Author: Alexandros Pantelopoulos
%
% 8/25/2011
%
% West Health Institute
%

% Check the input parameters
if (nargin < 3)
    startIndex = 20;
end
if (nargin < 2)
    errror('Please specify the following arguments (only): 1) data vector, 2) window size')
end

% Data vector length
dataLength = size(dataVector,1);
dataWidth  = size(dataVector,2);

% determine the number of outer iterations based on the floored ratio of
% dataLength/windowSize
numOuterIter = floor(dataLength/windowSize);

% Array for the autocorrelation result
autoCorrLength = numOuterIter * windowSize;
result = zeros(autoCorrLength,dataWidth);

% computation
for i = 1:numOuterIter
    
    tmp       = dataVector((i-1)*windowSize+1:i*windowSize,:);
    tmpEnergy = sum( tmp.^2 );

    for j = startIndex:windowSize
        
        if ( i*windowSize+(j-1) < dataLength )
            
           result((i-1)*windowSize+j,:) = sum( tmp .* dataVector((i-1)*windowSize+j:i*windowSize+(j-1),:) ).^2;
           normFactor = ( tmpEnergy ) .* ( sum( dataVector((i-1)*windowSize+j:i*windowSize+(j-1),:).^2 ) );
           result((i-1)*windowSize+j,:) = ( result((i-1)*windowSize+j,:) ./ normFactor );
           
        end
        
    end
    
end


