%This script will generate the validation set that will be used for
%cross-checking by the PhysionNet servers. 
%
%In order to be compatible with the testing environment, 
%you should have the training set located at the subdirectory the top 
%directory of where this file unzips (ie, where challenge.m is located)
%
% Once this script is run, the generated annotation files when then be moved to % ./challenge/2014/set-p/ (or .\challenge\2014\set-p\ in Windows).
%
% This location is where the scoring server expects the validating annotations % to reside.
%
%Althought this script can be run from MATLAB, it is best to have it run on
%an Octave 3.6.2 for the generation of final validation set. This script
%needs to be run from its current directory (sample-octave-entry).
%
%
%         Written by Ikaro Silva January 21, 2014.
%         Last Modified: July 23, 2014
%
%

clear all;close all;clc
ans_dir=[pwd filesep 'challenge' filesep '2014' filesep 'set-p'];

if(exist('OCTAVE_VERSION'))
   more off %this seems necessary in order to get back the screen in Octave
end

%Check for previous files before starting test
qrs=dir([ans_dir filesep '*.qrs']);
if(~isempty(qrs))
    while(1)
        display(['Found previous QRS files in:' ans_dir])
        cont=input('Delete them all (Y/N/Q)?','s');
        if(strcmp(cont,'Y') || strcmp(cont,'N') || strcmp(cont,'Q'))
            if(strcmp(cont,'Q'))
                display('Exiting script!!')
                return;
            end
            break;
        end
    end
    if(strcmp(cont,'Y'))
        display('Removing previous generated files.')
        for i=1:length(qrs)
            delete([ans_dir filesep qrs(i).name]);
        end
    end
end

fprintf('Generating validation set, please wait...\n')
%Start the validation
training=dir(['./*.dat']);
if(length(training) ~= 100)
    warning(['Training data does not have 100 records! Training set location: ' pwd ])
    warning(['Download training set at: http://www.physionet.org/physiobank/database/challenge/2014/set-p.zip to the current direcotry.'])
    error('Cannot continue because training set does not have 100 records.')
end

N=length(training); %This should always be 100, but we display it as an extra double check.
try
    total_time=0;
    for i=1:N
        fname=training(i).name;
        tic;
        %Remove .dat extension from file name
	display(['challenge(' fname(1:end-4) ');'])
        challenge(fname(1:end-4));
        total_time=total_time+toc;
        %Move the annotation file to the validation directory
        status=movefile([fname(1:end-4) '.qrs'],ans_dir);
        if(status !=1)
	  error(['Could not move file: ' fname(1:end-4) ' to: ' ans_dir])
        end
        if(~mod(i,10))
            fprintf(['---Annotated ' num2str(i) ' out of ' num2str(N) ' records.\n'])
        end
    end
    averageTime = total_time/N;
    fprintf(['Generation of validation set completed !! Total time= ' ...
        num2str(total_time) ' average time= ' num2str(averageTime) '\n'])
catch
    error(lasterr)
end

fprintf(['To  package your entry into a valid entry.zip submission file, on unix systems run : \n'])
fprintf(['\tzip -r entry.zip . -x ./*.dat -x ./*.hea \n'])





