% find_Q_on.m - Find Q_on using gradients
%        Copyright (C) 2006  Vaclav Chudacek
%        This software is released under the terms of the GNU General
%        Public License (http://www.gnu.org/copyleft/gpl.html).

function Q_on = find_Q_on(in_ECG)
ekg = slidingavg(in_ECG(1,1:150),5)+1000;

%%% Computation of gradients for Q-on detection
number_of_points = 0; previous_i = 0;
length_for_gradient = 150 - 10 -1;
for i = 1:length_for_gradient,
    gradient2(i) = ekg(end-i-10)-ekg(end-i);
end
for i=2:length_for_gradient,
    if ((gradient2(i-1)<0)&&(gradient2(i)>0))&&((gradient2(i)~=0)||(gradient2(i-1)~=0)),
        number_of_points = number_of_points + 1;
        points(number_of_points) = 147-i+3;
        values(number_of_points) = ekg(points(number_of_points));
        distance(number_of_points) = i - previous_i; previous_i = i;
    elseif((gradient2(i-1)>0)&&(gradient2(i)<0))&&((gradient2(i)~=0)||(gradient2(i-1)~=0))
        number_of_points = number_of_points + 1;
        points(number_of_points) = 147-i+3;
        values(number_of_points) = ekg(points(number_of_points));
        distance(number_of_points) = i - previous_i; previous_i = i;
    elseif (gradient2(i)==0)||(gradient2(i-1)==0)
        %disp('Nulovy gradient');
    end
end

%%% Q-on point selection
for i = 1:1%length(points)
    if values(1)<ekg(150) %%% R-wave positive
        %disp('Positive R => searching for neg/zero Q');
        
        if values(2) < values(1)
            if values(2)+100 > values(1)
                Q_on = points(2);
            else
                Q_on = points(1);
            end

        elseif length(values)>2,
            if (values(2) > values(1))&&(abs(values(2)-values(3))<150),
                if values(2)- values(1)>100,
                    %disp('Q onset found.');
                    Q_on = points(2);
                else
                    Q_on = points(1);
                end
            else
                Q_on = points(3);
            end

        elseif length(values)>1,
            if values(2)- values(1)>100,
                Q_on = points(2);
            else
                Q_on = points(1);
            end
        else
            Q_on = points(1);
        end
    
    %%% R-wave negative
    else
        %disp('Negative R => searching for neg/zero Q');
        if length(values)>2,

            if values(3) < values(2)
                Q_on = points(2);
            else
                if (values(3) > values(2)),
                    if values(3)- values(2)>100,
         %               disp('Q onset found.');
                        Q_on = points(3);
                    else
                        Q_on = points(2);
                    end
                end
            end
        elseif length(values)>1,
            Q_on = points(2);
        else
            Q_on = points(1);
        end
    end
end