% correct_T_off.m - Searches for T_off to the left from the one suggested
% by find_T_off.m
%        Copyright (C) 2006  Vaclav Chudacek
%        This software is released under the terms of the GNU General
%        Public License (http://www.gnu.org/copyleft/gpl.html).

function correctionT = correct_T_off(ekg_in)

correctionT =0;

ekg_temp = slidingavg(ekg_in,5);
ekg = ekg_temp(100:end);

for i = 1:length(ekg)-13,
    gradient2(i) = ekg(i+2)-ekg(i);
    gradient4(i) = ekg(i+4)-ekg(i);
    gradient8(i) = ekg(i+8)-ekg(i);
    gradient12(i) = ekg(i+12)-ekg(i);
end

maxim = max(abs(ekg));
minim = min(abs(ekg));
if (abs(maxim-minim) > 200)
    smallG = find(abs(gradient12)<min(40,(maxim-minim)/15));
    gradient12(smallG) = 0;
    a = find(gradient12==0);
    clear('smallG');
    smallG = find(abs(gradient8)<min(40,(maxim-minim)/15));
    gradient8(smallG) = 0;
    clear('smallG');
    b = find(gradient8==0);
    smallG = find(abs(gradient4)<min(30,(maxim-minim)/20));
    gradient4(smallG) = 0;
    clear('smallG');
    c = find(gradient4==0);
    smallG = find(abs(gradient2)<min(20,(maxim-minim)/30));
    gradient2(smallG) = 0;
    clear('smallG');
    d = find(gradient2==0);
else
    smallG = find(abs(gradient12)< 40);
    gradient12(smallG) = 0;
    a = find(gradient12==0);
    clear('smallG');
    smallG = find(abs(gradient8)< 40);
    gradient8(smallG) = 0;
    clear('smallG');
    b = find(gradient8==0);
    smallG = find(abs(gradient4)< 30);
    gradient4(smallG) = 0;
    clear('smallG');
    c = find(gradient4==0);
    smallG = find(abs(gradient2)< 20);
    gradient2(smallG) = 0;
    clear('smallG');
    d = find(gradient2==0);
end

correctionT = min([length(a) length(b) length(c) length(d)]);

if median([length(a) length(b) length(c) length(d)])> 85,
    ekg = ekg_temp(50:end);
    for i = 1:length(ekg)-13,
        gradient2(i) = ekg(i+2)-ekg(i);
        gradient4(i) = ekg(i+4)-ekg(i);
        gradient8(i) = ekg(i+8)-ekg(i);
        gradient12(i) = ekg(i+12)-ekg(i);
    end
    smallG = find(abs(gradient12)<40);
    gradient12(smallG) = 0;
    a = find(gradient12==0);
    clear('smallG');
    smallG = find(abs(gradient8)<40);
    gradient8(smallG) = 0;
    clear('smallG');
    b = find(gradient8==0);
    smallG = find(abs(gradient4)<30);
    gradient4(smallG) = 0;
    clear('smallG');
    c = find(gradient4==0);
    smallG = find(abs(gradient2)<20);
    gradient2(smallG) = 0;
    clear('smallG');
    d = find(gradient2==0);
    correctionT = min([length(a) length(b) length(c) length(d)]);
end