% correct_Q_on.m - Searches for better Q_ons in the +-20area of the
% suggested Q_on by Find Q_on.m 
%        Copyright (C) 2006  Michal Huptych, Vaclav Chudacek
%        This software is released under the terms of the GNU General
%        Public License (http://www.gnu.org/copyleft/gpl.html).

function korekceQ = correct_Q_on(ECGch,Q_on_FINAL_abs, Q_on_window_start, Q_on_window_stop)
k4r = 0; k6r = 0; k8r = 0;
k4l = 0; k6l = 0; k8l = 0;

gradient4right = abs(ECGch(Q_on_window_stop:-4:Q_on_FINAL_abs+4)-ECGch(Q_on_window_stop-4:-4:Q_on_FINAL_abs));
gradient4right = gradient4right(length(gradient4right):-1:1);
gradient6right = abs(ECGch(Q_on_window_stop:-6:Q_on_FINAL_abs+6)-ECGch(Q_on_window_stop-6:-6:Q_on_FINAL_abs));
gradient6right = gradient6right(length(gradient6right):-1:1);
gradient8right = abs(ECGch(Q_on_window_stop:-8:Q_on_FINAL_abs+8)-ECGch(Q_on_window_stop-8:-8:Q_on_FINAL_abs));
gradient8right = gradient8right(length(gradient8right):-1:1);

for i = 1:length(gradient4right)
    if (gradient4right(i) < 30)
        k4r = k4r+4;
    end
end
for i = 1:length(gradient6right)
    if (gradient6right(i) < 30)
        k6r = k6r+6;
    end
end
for i = 1:length(gradient8right)
    if (gradient8right(i) < 30)
        k8r = k8r+8;
    end
end

korekceQ = median([k4r k6r k8r]);
Q_on_FINAL_abs = Q_on_FINAL_abs + korekceQ;
if (((Q_on_FINAL_abs+20)-Q_on_FINAL_abs) > 35 && (Q_on_FINAL_abs -(Q_on_FINAL_abs-20)) > 35)
    gradient4left = abs(ECGch(Q_on_FINAL_abs:-4:Q_on_window_start+4)-ECGch(Q_on_FINAL_abs-4:-4:Q_on_window_start));
    gradient4left = gradient4left(length(gradient4left):-1:1);
    gradient6left = abs(ECGch(Q_on_FINAL_abs:-6:Q_on_window_start+6)-ECGch(Q_on_FINAL_abs-6:-6:Q_on_window_start));
    gradient6left = gradient6left(length(gradient6left):-1:1);
    gradient8left = abs(ECGch(Q_on_FINAL_abs:-8:Q_on_window_start+8)-ECGch(Q_on_FINAL_abs-8:-8:Q_on_window_start));
    gradient8left = gradient8left(length(gradient8left):-1:1);

    for i = 1:length(gradient4left)
        if (gradient4left(i) > 30)
            k4l = k4l-4;
        end
    end
    for i = 1:length(gradient6left)
        if (gradient6left(i) > 30)
            k6l = k6l-6;
        end
    end
    for i = 1:length(gradient8left)
        if (gradient8left(i) > 30)
            k8l = k8l-8;
        end
    end
    korekceQ = median([k4l k6l k8l]);
end