%~ trqt.m - Part of the trqt package submitted for the 2006 CinC challenge
%~ Copyright (C) 2006  DA Tironi, R Sassi and LT Mainardi
%~ This software is released under the terms of the GNU General
%~ Public License (http://www.gnu.org/copyleft/gpl.html).

SAMPLING_RATE = 1000; [b_high, a_high] = butter(5,0.5/(SAMPLING_RATE/2),'high'); %per il filtro

Col_RR = 1; %colonna RR
Col_Q = 2; %colonna punto Q
Col_T = 3; %colonna punto T
Col_P = 4; %colonna Pattern
Col_F = 5; %colonna famiglia
Col_QT = 6; %colonna QT

minSizeListaQT = 2;%se listaQT ha meno di queste righe QT viene impostato a 0
minSizePattern = 2;
diagnostica = 0;
listasufile = 0;
salvasufile = 0;

segnale = load('temp.sam');%carico il segnale

segnale = flipud(filter(b_high,a_high,flipud(filter(b_high,a_high,segnale(:,2),[],1)),[],1));%filtro il segnale

if(listasufile == 0)
    listaQT = load('temp.lqt'); %carico la lista dei punti q e t
    if(size(listaQT, 1) < minSizeListaQT)
        Q=0;
        T=0;
        return
    end
    %inizio cross correlazione
    miglioramento = 1;
    c1=1;
    while miglioramento > 0 && miglioramento / (c1^2) > 0.05;
        c1 = c1 +1;
        listaQT = rrpattern(listaQT);
        [listaQT, miglioramento] = shiftQT(listaQT, segnale);
        pause(0);
    end

    listaQT = rrpattern(listaQT);
    if(salvasufile == 1)
        save('temp.sqt', 'listaQT', '-ascii');
    end
else
    listaQT = load('temp.sqt');
end
     
listaQT(:,Col_QT) = listaQT(:,Col_T) - listaQT(:,Col_Q);%trovo la colonna QT

[indPattern, lungPattern] = findPattern(listaQT(:,[Col_F, Col_QT]), minSizePattern); %trovo la famiglia pi lunga
if(lungPattern < minSizePattern)
    Q=0;
    T=0;
    return
end

[scPuntoQ, isoelettrico] = findQ(listaQT(indPattern:indPattern + lungPattern - 1, Col_Q), segnale);%trovo lo scostamento rispetto al precedente punto Q
listaQT(:, Col_Q) = listaQT(:, Col_Q) + scPuntoQ;

[scPuntoT, XYretta] = findT(listaQT(indPattern:indPattern + lungPattern - 1, Col_T), segnale, isoelettrico);%trovo lo scostamento rispetto al precedente punto T
listaQT(:, Col_T) = listaQT(:, Col_T) + scPuntoT;

listaQT(:, Col_QT) = listaQT(:, Col_T) - listaQT(:, Col_Q);
QTmedio = round(mean(listaQT(indPattern:indPattern + lungPattern - 1, Col_QT)));

%preferito = findPreferito(listaQT(indPattern:indPattern + lungPattern - 1, Col_QT), indPattern);
preferito = indPattern;
Q = listaQT(preferito,Col_Q), %trovo il punto Q
T = listaQT(preferito,Col_Q) + QTmedio, %trovo il punto T

if(diagnostica==1)
    WIN_QT = max(listaQT(indPattern:indPattern + lungPattern - 1, Col_QT), 1)+50;
    START_Q = -20; WIN_Q =150;
    START_T = -130; WIN_T =150;
    figure(1)
    clf
    hold on
    for c1 = 0:min([20 lungPattern-1])
        plot([START_Q:START_Q+WIN_QT], segnale(listaQT(indPattern + c1, Col_Q)+START_Q:listaQT(indPattern + c1, Col_Q)+START_Q+WIN_QT)- 200*c1 -3000,'.-');
        plot(listaQT(indPattern + c1, Col_QT), segnale(listaQT(indPattern + c1, Col_T))- 200*c1 -3000,'r*')
    end
    FQmedio = meanWindow(listaQT(indPattern:indPattern+lungPattern-1,Col_Q), segnale, START_Q, WIN_Q);
    plot(START_Q:WIN_Q+START_Q-1,FQmedio,'.-g');%stampa la media
    FTmedio = meanWindow(listaQT(indPattern:indPattern+lungPattern-1,Col_T), segnale, START_T, WIN_T);
    plot((START_T:WIN_T+START_T-1)+(QTmedio),FTmedio,'.-g');%stampa la media
    plot(QTmedio-size(XYretta(1, :),2)+1:QTmedio, XYretta(2, :),'.-b');%stampa la retta
    cretta = round(size(XYretta(1, :),2)/2);
    plot(QTmedio-size(XYretta(1, :),2)+1+cretta, XYretta(2, 1+cretta),'r*');%stampa il punto di der minima
    
%     posPuntoDerMinima=1+10+(21-1)/2; %bruttissimo
%     plot(XYretta(1, posPuntoDerMinima)+QTmedio, XYretta(2, posPuntoDerMinima),'r*');%stampa il punto di der minima
    
    plot(QTmedio, XYretta(2, size(XYretta,2)),'r*');%stampa il punto t
    plot(QTmedio, ylim, 'r:');
    
    plot(xlim, [isoelettrico isoelettrico], 'b:');%stampa il tratto isoelettrico
    plot([0 0], ylim, 'b:');

    hold off
end

%{
ANNOTAZIONI

%}