%~ shiftQT.m - Part of the trqt package submitted for the 2006 CinC challenge
%~ Copyright (C) 2006  DA Tironi, R Sassi and LT Mainardi
%~ This software is released under the terms of the GNU General
%~ Public License (http://www.gnu.org/copyleft/gpl.html).

function[listaQT, scostamento] = shiftQT(listaQT, segnale)

Col_RR = 1; %colonna RR
Col_Q = 2; %colonna punto Q
Col_T = 3; %colonna punto T
Col_F = 5; %colonna famiglia

dim_frame_xcorrQ = 150;
start_frame_xcorrQ = -10;
dim_frame_xcorrT = 250;
start_frame_xcorrT = -200;
shift = 100;

scQ = 0; scT = 0;
c2 = 1;
for c1 = 2:size(listaQT, 1)%per ogni battito a partire dal secondo
    if(listaQT(c1, Col_F)==0 || c1==size(listaQT, 1))%se il battito fa parte della stessa famiglia
        if(c2 > 1)%se la famiglia ha pi di un battito
            if(c1==size(listaQT, 1) && listaQT(c1, Col_F)==1)
                c1 = c1+1;
                c2 = c2+1;
            end
            for c3 = c1-c2:c1-1%per ogni battito della famiglia
                mediaQ = meanWindow(listaQT(c1-c2:c1-1, Col_Q), segnale, start_frame_xcorrQ, dim_frame_xcorrQ);%trovo la media dell'intorno di Q
                mediaT = meanWindow(listaQT(c1-c2:c1-1, Col_T), segnale, start_frame_xcorrT, dim_frame_xcorrT);%trovo la media dell'intorno di T
                for c4 = -shift:shift%per X campioni a sx e X a dx
                    arrCorrQ(c4+shift+1, :) = xcorr(segnale(listaQT(c3, Col_Q)+start_frame_xcorrQ + c4:listaQT(c3, Col_Q)+start_frame_xcorrQ + c4+dim_frame_xcorrQ-1), mediaQ, 'coeff');%trovo le crosscorrelazioni della finestra specifica
                    arrCorrT(c4+shift+1, :) = xcorr(segnale(listaQT(c3, Col_T)+start_frame_xcorrT + c4:listaQT(c3, Col_T)+start_frame_xcorrT + c4+dim_frame_xcorrT-1), mediaT, 'coeff');%trovo le crosscorrelazioni della finestra specifica
                end

                [maxQ, scQiter] = max(arrCorrQ(:, dim_frame_xcorrQ));%trovo la crosscorrelazione massima di Q
                listaQT(c3, Col_Q) = listaQT(c3, Col_Q) + scQiter - shift - 1;%adatto il punto Q alla cr.corr max
                scQ = scQ + abs(scQiter - shift - 1);%riporto lo scostamento di Q
                [maxT, scTiter] = max(arrCorrT(:, dim_frame_xcorrT));%trovo la crosscorrelazione massima di T
                listaQT(c3, Col_T) = listaQT(c3, Col_T) + scTiter - shift - 1;%adatto il punto T alla cr.corr max
                scT = scT + abs(scTiter - shift - 1);%riporto lo scostamento di T

            end
        end
        c2 = 1;
    else
        c2 = c2+1;
    end
end

scostamento = scQ + scT;%trovo lo scostamento totale di tutti i battiti