%~ findT.m - Part of the trqt package submitted for the 2006 CinC challenge
%~ Copyright (C) 2006  DA Tironi, R Sassi and LT Mainardi
%~ This software is released under the terms of the GNU General
%~ Public License (http://www.gnu.org/copyleft/gpl.html).

function [puntoT, retta] = findT(listaT, segnale, Y)

dim_fin_der = 21; %per mediare ogni derivata con precedenti e successive (deve essere dispari)
startWindow = -100;
lengthWindow = 140;

FTmedio = meanWindow(listaT, segnale, startWindow, lengthWindow);%trovo la finestra del punto T medio.
if (mean(FTmedio, 2) < FTmedio(1,lengthWindow))
    FTmedio=FTmedio*(-1);
end

for c1 = 1: lengthWindow - dim_fin_der +1
    [mqRetta(c1, :)] = polyfit(c1:c1+dim_fin_der-1, FTmedio(c1:c1+dim_fin_der-1), 1);
end

[MIN, I] = min(mqRetta(:, 1));%trovo la derivata minima

X = round((Y - mqRetta(I, 2))/MIN); %trovo il punto T
puntoT = X + startWindow;

if(X > I)
    retta(1, :) = [startWindow+I:puntoT];
    retta(2, :) = MIN*[I:X]+mqRetta(I, 2);
else
    retta(1, :) = [puntoT:startWindow+I];
    retta(2, :) = MIN*[X:I]+mqRetta(I, 2);
end


% qRetta = mqRetta(I, 2);
% Ypunto = FTmedio(1, I);
% Xpunto = I;

% figure(6)
% plot(mqRetta(:, 1),'.-');
% 
% figure(20)
% plot(FTmedio,'.');
% hold on
% 
% hold off