%~ findQ.m - Part of the trqt package submitted for the 2006 CinC challenge
%~ Copyright (C) 2006  DA Tironi, R Sassi and LT Mainardi
%~ This software is released under the terms of the GNU General
%~ Public License (http://www.gnu.org/copyleft/gpl.html).

function [puntoQ, isoelettrico] = findQ(listaQ, segnale)
startWindow = -100;
lung_segm = 20;
lengthWindow = abs(startWindow)*2 - lung_segm;
isoelettrico = 0;


FQmedio = meanWindow(listaQ, segnale, startWindow, lengthWindow);%trovo la finestra del punto Q medio.
if(findIsoeletric(FQmedio(0 - startWindow - lung_segm:1 - startWindow)) == 1)%se il punto Q  nel tratto isoelettrico
    verso = 1;
else
    verso = -1;
end
puntoQ = 0;
c2 = 1;
cond = -1;
while 2 * cond + verso ~= 1 && c2*verso - startWindow - lung_segm > 1 && c2*verso + 1 - startWindow <= lengthWindow%finch nn esco dal tratto isoelettrico o nn ci entro 
    cond = findIsoeletric(FQmedio(c2*verso - startWindow - lung_segm:c2*verso + 1 - startWindow));%sono nel tratto isoelettrico?
    c2 = c2 + 1;
end
if(c2*verso - startWindow - lung_segm <= 1 || c2*verso + 1 - startWindow > lengthWindow)
    puntoQ = 0;
else
    c2 = c2 - 1;
    if(verso == 1)
        puntoQ = verso * (c2 - 1);
    else
        puntoQ = verso * c2;
    end
end

isoelettrico = mean(FQmedio(1, puntoQ + 1 - startWindow - lung_segm:puntoQ - startWindow));%trovo il valore isoelettrico

% figure(1)
% plot(FQmedio,'.');
% hold on
% plot(puntoQ - startWindow, [-500:500], '.');
% hold off



function [risposta] = findIsoeletric(window)

media = mean(window);%calcolo la media dei campioni = tratto isoelettrico
diff = abs(window(:, size(window, 2)- 5:size(window, 2)) - media);%calcolo le differenze degli ultimi 6 campioni dalla media
if((diff(size(diff, 2)) < 20) && (size(find(diff < 20), 2) >= 4))%se degli ultimi 6 nn l'ultimo e almeno 4 sono nell'intorno di 20
    risposta = 1;%il punto  nel tratto isoelettrico
else
    risposta = 0;%il punto nn  nel tratto isoelettrico
end

%     [window, map] = sort(window);
% if(abs(window(1) - window(4)) < 30 && map(5)~=6 && map(6)~=6)
%     risposta = 1;
% elseif(abs(window(2) - window(5)) < 30 && map(1)~=6 && map(6)~=6)
%     risposta = 1;
% elseif(abs(window(3) - window(6)) < 30 && map(1)~=6 && map(2)~=6)
%     risposta = 1;
% else
%     risposta = 0;
% end
