/*  cqrs.c - Part of the trqt package submitted for the 2006 CinC challenge
    Copyright (C) 2006  DA Tironi, R Sassi and LT Mainardi
    This software is released under the terms of the GNU General
    Public License (http://www.gnu.org/copyleft/gpl.html).
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#define LVETT1 10000
#define LRIGAFILE 43

typedef struct{
	char s1[4];
	char tempo[8];
	char s2[2];
	char campione[7];
	char s3[5];
	char anntyp[1];
	char s4[4];
	char subtyp[1];
	char s5[4];
	char chan[1];
	char s6[4];
	char num[1];
}Rigagrezza;
typedef struct{
	char tempo[8];
	long campione;
	char anntyp[1];
	short subtyp;
	short chan;
	short num;
}Riga;
typedef struct{
	short seq;
	long riga;
	long q;
	long t;
	long freq;
}Misurazioni;

void filtra(Riga *righe, Misurazioni *misurazioni, int length){
	int c1=0, c2=0, c3=0, c4=0, c5=0, c6=0;
	char sequenza[]="(p)(N)(t)";

	while(*(righe[c4].anntyp) != 'N')
		c4++;
	c5=c4;

	for(c2=c4;c2<length;c2++){
		if(c1==9){
			misurazioni[c3].riga = (c2-9)+1;
			misurazioni[c3].seq = (c3==0 ||misurazioni[c3].riga==misurazioni[c3-1].riga+9+c6)?1:0;
			misurazioni[c3].q = righe[c2-6].campione;
			misurazioni[c3].t = righe[c2-1].campione;
			misurazioni[c3].freq = righe[c2-5].campione - righe[c5].campione;
			c1=0;
			c3++;
			c6=0;
		}
		if(*(righe[c2].anntyp) == 'N'){
			c5=c4;
			c4=c2;
		}
		if(*(righe[c2].anntyp) == sequenza[c1])
			c1++;
		else if(c1==8 && righe[c2].num>3 && *(righe[c2].anntyp)=='t' && *(righe[c2-1].anntyp)=='t')
			c6++;
		else
			c1=0;
	}

}

int main(int argc, char *argv[ ]){
	int c1=0, c2=0; //contatori
	Misurazioni misurazioni[LVETT1/9];
	Rigagrezza rigagrezza; //buffer di lettura delle righe del file
	Riga righe[LVETT1]; //elenco delle righe
	FILE *fin; //puntatore al file
	
	for(c2=0;c2<LVETT1/9;c2++)
		misurazioni[c2].riga=0;

	if((fin = fopen(argv[1], "r")) == NULL)
		return -1;
	
	while(fread(&rigagrezza, LRIGAFILE, 1, fin)){
		if(c1<=LVETT1){
			strcpy(righe[c1].tempo, rigagrezza.tempo);
			righe[c1].campione = atoi(rigagrezza.campione);
			strcpy(righe[c1].anntyp, rigagrezza.anntyp);
			righe[c1].subtyp = atoi(rigagrezza.subtyp);
			righe[c1].chan = atoi(rigagrezza.chan);
			righe[c1].num = atoi(rigagrezza.num);
			c1++;
		}
	}
	if(c1>LVETT1){
		printf("ERROR: a few lines are missing!");
		return -1;
	}	

	filtra(righe, misurazioni, c1);
	
	for(c2=0;misurazioni[c2].riga>0;c2++)
		printf("%li\t%li\t%li\t%i\n", misurazioni[c2].freq, misurazioni[c2].q, 
      misurazioni[c2].t, misurazioni[c2].seq);

	return 0;
}
