% -------------------------------------------------------------------------------------------------
% TSmerge.m: 
%
% Copyright (C) 2004 Federico Cantini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: federico.cantini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function out = TSmerge (main_dir, CasiDir, record_list)

if nargin < 1
    record_learn ={'t01','t02','t03','t04','t05','t06','t07','t08','t09','t10','s01','s02','s03','s04','s05','s06','s07','s08','s09','s10'};
    record_list = record_learn;
    main_dir = '.\';
end
    
for ii = 1:length(record_list)
	clear beatGroup;
	file = fullfile(main_dir, 'DatiQc',CasiDir,[record_list{ii},'_QRSclass2.mat']);
	load (file);
	max_jj 	= 1;
	max_num = length(beatGroup.vq{1});
	for jj = 2:length (beatGroup.vq)
		if (length(beatGroup.vq{1}) > max_num)
			max_num = length(beatGroup.vq{1});
			max_jj = jj;
        end
    end
	QRSclass{ii} = beatGroup.avgC1Q(:,max_jj);
end

for ii = 1:length(QRSclass)/2
	for jj = 1:length(QRSclass)
		if (ii ~= jj)
			d(jj) = dist_p(QRSclass{ii},QRSclass{jj});
		else
			d(jj) = 99999999;
        end
    end

	[pat(ii).value,pat(ii).ind] = min(d);
end

for ii = 1:length(QRSclass)/2
    out {ii,1} = record_list{ii};
    out {ii,2} = record_list{pat(ii).ind};
	fprintf('%s <--> %s\n',record_list{ii},record_list{pat(ii).ind});    
end



