% -------------------------------------------------------------------------------------------------
% SpettriEvB.m: 
%
% Copyright (C) 2004 Federico Cantini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: federico.cantini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function score = SpettriEvB(mainPath_in,casiDir,casoT,casoS)

echo off

close all
debug=0;
graf=0;
extension = '.dat';
ns=8;

mainPath_in= [mainPath_in, casiDir];
fpname = fullfile(mainPath_in, [casoT extension]);
fprintf('Lettura del file: %s\n', fpname);
fid  = fopen(fpname,'r');
[datapT, count] = fread(fid,[ns,inf],'double');
fclose(fid);

fpname = fullfile(mainPath_in, [casoS extension]);
fprintf('Lettura del file: %s\n', fpname);
fid  = fopen(fpname,'r');
[datapS, count] = fread(fid,[ns,inf],'double');
fclose(fid);


fs = 1024;

Fmin = 3;
t1 = 56;
t2 = 58;
t4 = 60;


Ch = 7;

[ft2T,fp2] = specgram(datapT(Ch,fs*t1 + 1:fs*t2),length(datapT(Ch,fs*t1 + 1:fs*t2)),1024,ones(1,length(datapT(Ch,fs*t1 + 1:fs*t2))),0);
[ft3T,fp3] = specgram(datapT(Ch,fs*t2 + 1:fs*t4),length(datapT(Ch,fs*t2 + 1:fs*t4)),1024,ones(1,length(datapT(Ch,fs*t2 + 1:fs*t4))),0);

[ft2S,fp2] = specgram(datapS(Ch,fs*t1 + 1:fs*t2),length(datapS(Ch,fs*t1 + 1:fs*t2)),1024,ones(1,length(datapS(Ch,fs*t1 + 1:fs*t2))),0);
[ft3S,fp3] = specgram(datapS(Ch,fs*t2 + 1:fs*t4),length(datapS(Ch,fs*t2 + 1:fs*t4)),1024,ones(1,length(datapS(Ch,fs*t2 + 1:fs*t4))),0);



bi2 = min(find(fp2>Fmin));
ei2 = max(find(fp2<=10));

bi3 = min(find(fp3>Fmin));
ei3 = max(find(fp3<=10));

[maxT56_58, imaxT56_58] = max(abs(ft2T((bi2:ei2))).^2);
[maxT58_60, imaxT58_60] = max(abs(ft3T((bi3:ei3))).^2);
FmaxT56_58 = fp2(bi2+imaxT56_58);
FmaxT58_60 = fp3(bi3+imaxT58_60);

[maxS56_58, imaxS56_58] = max(abs(ft2S((bi2:ei2))).^2);
[maxS58_60, imaxS58_60] = max(abs(ft3S((bi3:ei3))).^2);
FmaxS56_58 = fp2(bi2+imaxS56_58);
FmaxS58_60 = fp3(bi3+imaxS58_60);


if (graf)

    hold off
    subplot(2,1,1)
    plot(fp2(bi2:ei2),28*abs(ft2S((bi2:ei2))).^2,'--b')
    hold on
    h=plot(fp3(bi3:ei3),28*abs(ft3S((bi3:ei3))).^2,'--r');
    title(casoS)
    hold off
    subplot(2,1,2)
    plot(fp2(bi2:ei2),28*abs(ft2T((bi2:ei2))).^2,'b')
    hold on
    h=plot(fp3(bi3:ei3),28*abs(ft3T((bi3:ei3))).^2,'r');
    title(casoT)
    xlabel('56-60 s')   
    figname = ['fig\' casiDir '\' casoT '_' casoS '_56-60'];
    %saveas(h,figname,'jpeg');
    hold off
end


score = 0;
if (FmaxT58_60 < FmaxT56_58) score = score+1; end
if (FmaxT58_60 > FmaxT56_58) score = score-1; end
if (FmaxS58_60 < FmaxS56_58) score = score-1; end
if (FmaxS58_60 > FmaxS56_58) score = score+1; end

if (score == 0)
    if (FmaxT58_60 < FmaxS58_60) score = score +1; end
    if (FmaxT58_60 > FmaxS58_60) score = score -1; end
end
score

