% -------------------------------------------------------------------------------------------------
% plotSgnMrkN.M: Plot signals (on multiple horizontal strips) with vertical markers.
%                --> With signal normalization
%                sgn    = signal matrix
%                pqrs   = vector of time indexes (markers)
%                freq   = sampling frequency
%                name   = figure title
%                nsecr  = number of seconds per row
%                nbands = number of strips per page
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function PlotSgnMrkN(sgn,pqrs,freq,name, nband, nsecr)
% convert column to row if necessary
[m,n] = size(sgn);  if n<m,   sgn = sgn.';   end
[m,n] = size(pqrs); if n<m,  pqrs = pqrs.';   end
yminc=min(sgn,[],2);
ymaxc=max(sgn,[],2);
nsgn=size(sgn,1);
nsampt=size(sgn,2);
if(nargin<3) freq=1; end
nsect=nsampt/freq;
if(nargin<4) name=''; end
if(nargin<5) nband=6; end
% if(nargin<6) nsecr=10; end
if(nargin<6) nsecr=nsect/nband; end
nsampr=nsecr*freq;   % number of samples per row
isampi=1;
isampf=0;
vmrkcol=['m', 'b', 'r', 'g', 'k'];

while isampf < nsampt
    figure
    for i=0:nband-1
        subplot(nband,1,i+1);
        isampf = isampi+nsampr-1;
        if(isampf > nsampt) isampf=nsampt; end;
%        yminc=min(sgn(:,isampi:isampf),[],2);
%        ymaxc=max(sgn(:,isampi:isampf),[],2);
        ymin=-1; ymax=1;
        yn=(ymax-ymin)./(ymaxc-yminc);
        yoffset=(1*(ymax-ymin)).*((nsgn:-1:1)-1)';
        clear ysgn;
        for is=1:nsgn
            ysgn(is,:)= yoffset(is) +ymin + yn(is)*(sgn(is,isampi:isampf)-yminc(is));
        end
        yming=ymin;
        ymaxg=ymax+max(yoffset);
        xmin=isampi/freq;
        xmax=(isampi+nsampr)/freq;
        plot([isampi:isampf]/freq ,ysgn);
        axis tight;
        if(i==0) ht=title(name); set(ht,'Interpreter','none'); end;
        XLIM([xmin, xmax]);
        YLIM([yming, ymaxg]);
        if(~isempty(pqrs))
            hold on;
            for im=1:size(pqrs,1);  % loop on marker type
                vmrk=pqrs(im,:);
                mrkcol=vmrkcol(mod(im,size(vmrkcol,2)));
                iqrsint=find((isampi < vmrk)&(isampf > vmrk));
                pqrsint=vmrk(iqrsint); 
                fxpqrs=[pqrsint; pqrsint]/freq;
                fypqrs = ones(size(fxpqrs)); fypqrs(1,:)=yming; fypqrs(2,:)=ymaxg;
                plot(fxpqrs,fypqrs, [mrkcol ':+']);
            end
        end
        if(isampf == nsampt) break; end;
        isampi = isampf+1;
    end
end
