% -------------------------------------------------------------------------------------------------
% plotSgnMrk.M: Plot signals (on multiple horizontal strips) with vertical markers
%               sgn    = signal matrix
%               pqrs   = vector of time indexes (markers)
%               freq   = sampling frequency
%               name   = figure title
%               nsecr  = number of seconds per row
%               nbands = number of strips per page
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function PlotSgnMrk(sgn,pqrs,freq,name, nband, nsecr)
% convert column to row if necessary
[m,n] = size(sgn);  if n<m,   sgn = sgn.';   end
[m,n] = size(pqrs); if n==1,  pqrs = pqrs.';   end
ymin=min(min(sgn));
ymax=max(max(sgn));
nsampt=size(sgn,2);
nsect=nsampt/freq;
if(nargin<4) name=''; end
if(nargin<5) nband=6; end
%if(nargin<6) nsecr=10; end
if(nargin<6) nsecr=nsect/nband; end
nsampr=nsecr*freq;   % number of samples per row
isampi=1;
isampf=0;

while isampf < nsampt
    figure
    for i=0:nband-1
        subplot(nband,1,i+1);
        isampf = isampi+nsampr;
        if(isampf > nsampt) isampf=nsampt; end;
%        ymin=min(min(sgn(:,isampi:isampf)));
%        ymax=max(max(sgn(:,isampi:isampf)));
        xmin=isampi/freq;
        xmax=(isampi+nsampr)/freq;
        plot([isampi:isampf]/freq, sgn(:,isampi:isampf));
        axis tight;
        if(i==0) ht=title(name); set(ht,'Interpreter','none'); end;
        XLIM([xmin, xmax]);
        YLIM([ymin, ymax]);
        if(~isempty(pqrs))
            hold on;
            iqrsint=find((isampi < pqrs)&(isampf > pqrs));
            pqrsint=pqrs(iqrsint); 
            fxpqrs=[pqrsint; pqrsint]/freq;
            fypqrs = ones(size(fxpqrs)); fypqrs(1,:)=ymin; fypqrs(2,:)=ymax;
            plot(fxpqrs,fypqrs, 'm:+');
        end
        if(isampf == nsampt) break; end;
        isampi = isampf;
    end
end
