% -------------------------------------------------------------------------------------------------
% mimaxsc.m: Compute the minimum and the maximum value of a vector excluding the distribution tails.
%            "perci" = % of min values;  "percf" = % of max values to be excluded
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

% [mi, ma] = mimaxsc(v,perci,percf)
function [mi, ma] = mimaxsc(v,perci,percf)
vo=sort(v);
ii = 1 + floor(length(v)*perci/100);
fi = floor(length(v)*(1 - percf/100));
mi=min(vo(ii:fi));
ma=max(vo(ii:fi));
