% -------------------------------------------------------------------------------------------------
% eventA.m
% The PhysioNet Challenge (event A): Predicting the End of an Atrial Fibrillation Episode
% 
% Read all the cases of Physionet Atrial Fibrillation database and classify them in 
% persistent AF and paroxysmal AF.
%
% Input parameters:
% mainPath_in 	-> Atrial fibrillation database main directory
%                   (example: '..\..\www.physionet.org\physiobank\database\aftdb')
% mainPath	-> Main data directory
%                   (example: '..\..\')
% 
% The "eventA.m" procedure executes the following routines:
% - "QrsAvgCancelAll.m"       
%     ("QrsAvgCancelTestClPcan.m": QRST canceling)
% - "StftSpettriMedianAll.m"
%     ("StftSpettriMedian.m": spectrum estimation)
% - "ResultTest.m"
%     (classification)
% - - -
% Input files:
% mainPath_in\caseDir\cname.dat
% where: "caseDir" is one of the following: "learning-set", "test-set-a", "test-set-b";
%        "cname" the name of one case
% (example: '..\..\www.physionet.org\physiobank\database\aftdb\learning-set\n01.dat')
% 
% Output files of "QrsAvgCancelTestClPcan.m" routine:
%  directory mainPath\DatiQc\caseDir    (example: '..\..\DatiQc\learning-set')
%    'cname.dat' containing signals after QRST canceling
%       (example: '..\..\DatiQc\learning-set\n01.dat')
%    'cname.mat' containing some parameters (RR interval series, the mean RR, ...)
%       (example: '..\..\DatiQc\learning-set\n01.mat')
% 
% Output files of "StftSpettriMedian.m" routine:
%  directory mainPath\DatiQc\caseDir\SptRes
%        (example: '..\..\DatiQc\learning-set\SptRes')
%    'cname.mat' containing the parameters of the previuos parameter file (cname.mat) 
%                updated with spectral measures: 'fPmaxb', 'Pdmaxb'
%  directory mainPath\DatiQc\caseDir\SptRes\figure
%        (example: '..\..\DatiQc\learning-set\SptRes\figure')
%    'cname.jpg' containing the figure of Power Density Spectrum
% 
% Output files of "ResultTest.m" routine:
%  directory mainPath\DatiQc
%        (example: '..\..\DatiQc')
%    'ResultTab.txt' containing the classification results of all the cases 
%                    of all the set.
% 
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function eventA (mainPath_in, mainPath_out)

    if(nargin < 1)  mainPath_in='..\..\www.physionet.org\physiobank\database\aftdb'; end
    if(nargin < 2)  mainPath_out='..\..\'; end
    
    QrsAvgCancelAll(mainPath_in, mainPath_out);

    mainPath_out=fullfile(mainPath_out,'DatiQc');
    StftSpettriMedianAll(mainPath_out);
    
    ResultTest(mainPath_out);
    
end