% -------------------------------------------------------------------------------------------------
% StftSpettriMedianAll.m: Calculate the spectra of all the cases in the subdirectories
%                         'learning-set', 'test-set-a', 'test-set-b' of the directory ..\DatiQc.
% Data files on such directories are the result of the previous processing
% with the QRST canceling routine 'QrsAvgCancelAll.m'.
% For each case a call to the routine 'StftSpettriMedian.m' is executed.
%
% input parameter:
% mainPath = main path for input data files (generated by procedure "QrsAvgCancelTestClPcan.m")
%
% input files (generated by the procedure "QrsAvgCancelTestClPcan.m"):
%    signal files (.dat), usually 4 channels the last obtained cancelin QRST from ecg signals.
%    parameter files (.mat),  containing: 'RRs', 'RRmean', 'RRstd', 'nc', 'crrf', 'rp1fn', 'rp2fn'
% output file :
%    (directory "SptRes") parameter files (.mat) updated with spectral measures: 'fPmaxb', 'Pdmaxb'
%    (directory "SptRes\figure") figure files (.jpg) representing the spectrum of the estimate atrial signal
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

% 	tipoC='n'    % case type: N not terminated,  T terminated,  S terminated after....
function StftSpettriMedianAll(mainPath)

    if(nargin < 1)  mainPath='..\..\DatiQc\'; end

    modifier='';
    freq=1024;
    ics=4;        % index of signal to be processed

    casiDir='learning-set';
    tipoC='n'    %  N not terminated
    StftSpettriMedianDir(mainPath, casiDir, tipoC, modifier, ics, freq );
    
    tipoC='s'    %  
    StftSpettriMedianDir(mainPath, casiDir, tipoC, modifier, ics, freq );
    
    tipoC='t'    %  
    StftSpettriMedianDir(mainPath, casiDir, tipoC, modifier, ics, freq );
    
    casiDir='test-set-a';
    tipoC='a'    %  ??
    StftSpettriMedianDir(mainPath, casiDir, tipoC, modifier, ics, freq );
    
    casiDir='test-set-b';
    tipoC='b'    %  ??
    StftSpettriMedianDir(mainPath, casiDir, tipoC, modifier, ics, freq );
    
end    

function StftSpettriMedianDir(mainPath, casiDir, tipoC, modifier, ics, freq)
fprintf('------------------- Start processing of  %s ---------------------\n', casiDir);
lista= dir(fullfile(mainPath, casiDir, [tipoC,'*', modifier,'.dat']));
for i=1:length(lista)
    [path, nname, ext] = fileparts(lista(i).name); 
    StftSpettriMedian(mainPath, casiDir, nname, ics, freq);
    close all;
end;
fprintf('----------------------- End of processing  ---------------------\n');

clear all