% -------------------------------------------------------------------------------------------------
% ResultTest.m: Classification of all cases for event A
%               using a linear discriminant function in the (RR, Fm) plane,
%               or in the (HR, Fm) plane.
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function ResultTest(MainDataDir)

if(nargin < 1)  MainDataDir='..\..\DatiQc'; end

% List of cases of the test set whose type turned out 
% from the previous classification submissions
casinotiaT={'a19', 'a29'};
casinotiaN={'a10', 'a15', 'a22', 'a26', 'a28'};

casinotibT={'b07', 'b17'};
casinotibS={'b02', 'b10'};

% -----------------------------------------------------------------------------------------
FpTh=5.5;
% line in the plane RR, Fm
% The following points are chosen using all the known cases
RRr(1)=1.61; Fmr(1)=3;
RRr(2)=0.2; Fmr(2)=7.2;
% compute slope and intercept of the line through two points 
% in the plane (RR, Fm).
r_ang= (Fmr(2)-Fmr(1))/(RRr(2)-RRr(1));
r_int= Fmr(1) - r_ang* RRr(1);

% line in the plane HR, Fm 
HRr(1)=40; Fmrh(1)=4.6;
HRr(2)=200; Fmrh(2)=8;
rh_ang= (Fmrh(2)-Fmrh(1))/(HRr(2)-HRr(1));
rh_int= Fmrh(1) - rh_ang* HRr(1);
% -----------------------------------------------------------------------------------------


filepath_out= MainDataDir;
WriteFile=1;
% -----------------------------------------------------------------------------------------
if(1)
MainDataPath=fullfile(MainDataDir,'learning-set');
ResDataPath=fullfile(MainDataPath,'SptRes');
j=1
tipoC='n';    % case type: N not terminated,  T terminated,  S terminated after ....
fprintf('%s\n', ResDataPath);
lista= dir(fullfile(ResDataPath, [tipoC,'*', '.mat']));
for i=1:length(lista)
    [path, nname, ext] = fileparts(lista(i).name);
    fileName= fullfile(ResDataPath,lista(i).name);
%    fprintf('Reading parameters from file: %s\n', fileName);
    par{j}(i)=load(fileName);    %  RRs RRmean RRstd nc crr rp1fn rp2fn
    cname{j}{i}=nname;
end;

j=j+1;
tipoC='t';    % case type: N not terminated,  T terminated,  S terminated after ....
fprintf('%s\n', ResDataPath);
lista= dir(fullfile(ResDataPath, [tipoC,'*', '.mat']));
for i=1:length(lista)
    [path, nname, ext] = fileparts(lista(i).name);
    fileName= fullfile(ResDataPath,lista(i).name);
%    fprintf('Reading parameters from file: %s\n', fileName);
    par{j}(i)=load(fileName);    %  RRs RRmean RRstd nc crr rp1fn rp2fn
    cname{j}{i}=nname;
end;

j=j+1;
tipoC='s';    % case type: N not terminated,  T terminated,  S terminated after ....
fprintf('%s\n', ResDataPath);
lista= dir(fullfile(ResDataPath, [tipoC,'*', '.mat']));
for i=1:length(lista)
    [path, nname, ext] = fileparts(lista(i).name);
    fileName= fullfile(ResDataPath,lista(i).name);
%    fprintf('Reading parameters from file: %s\n', fileName);
    par{j}(i)=load(fileName);    %  RRs RRmean RRstd nc crr rp1fn rp2fn
    cname{j}{i}=nname;
end;

for j=1:3
    for i=1:size(par{j},2)
        Pdmaxm{j}(i)=par{j}(i).Pdmaxb;
        Fmaxm{j}(i)=par{j}(i).fPmaxb;
        RRmean{j}(i)=par{j}(i).RRmean;
    end
    HRmean{j}= 60./RRmean{j};
end
%  Classification of all the cases in learning set
for j=1:3
    cTh{j}= 1 + (Fmaxm{j} > FpTh);
    Cl{j} = 1 + (Fmaxm{j} > r_ang* RRmean{j} + r_int); 
%     Cl{j} = 1 + (Fmaxm{j} > rh_ang* HRmean{j} + rh_int); 
end

for j=1:3
    fprintf('case\tcl\tcth\tFmaxm\tRRmean\n');
    for i=1:size(cname{j},2) fprintf(' %s\t%d\t%d\t%6.3f\t%6.3f\n', cname{j}{i}, Cl{j}(i), cTh{j}(i), Fmaxm{j}(i),RRmean{j}(i)); end
    fprintf('n. cases of type 1 = %d,   %d\n', sum(Cl{j}==1), sum(cTh{j}==1));
    fprintf('n. cases of type 2 = %d,   %d\n', sum(Cl{j}==2), sum(cTh{j}==2));
end
fprintf('min freq. for type 1 = %f\n', min(Fmaxm{1}));
fprintf('max freq. for type 2 = %f\n', max(Fmaxm{2}));
fprintf('max freq. for type 3 = %f\n', max(Fmaxm{3}));
fprintf('min freq. for type 3 = %f\n', min(Fmaxm{3}));
% ---------------------------------------------------------------------------------------------------------
if(WriteFile)
    % Write on file the results
    fnameRes= fullfile(filepath_out, ['ResultTab', '.txt']);
    fidw = fopen(fnameRes,'Wt');
    fprintf(fidw,'%s\n', ResDataPath);
    fprintf(fidw,'Date: %s\n', date);
    for j=1:3
        fprintf(fidw,'case\tcl\tcth\tFmaxm\tRRmean\n');
        for i=1:size(cname{j},2) fprintf(fidw,' %s\t%d\t%d\t%6.3f\t%6.3f\n', cname{j}{i}, Cl{j}(i), cTh{j}(i), Fmaxm{j}(i),RRmean{j}(i)); end
        fprintf(fidw,'n. casi tipo 1 = %d,  %d\n', sum(Cl{j}==1), sum(cTh{j}==1));
        fprintf(fidw,'n. casi tipo 2 = %d,  %d\n', sum(Cl{j}==2), sum(cTh{j}==2));
    end
    fprintf(fidw,'min freq. for type 1 = %f\n', min(Fmaxm{1}));
    fprintf(fidw,'max freq. for type 2 = %f\n', max(Fmaxm{2}));
    fprintf(fidw,'max freq. for type 3 = %f\n', max(Fmaxm{3}));
    fprintf(fidw,'min freq. for type 3 = %f\n', min(Fmaxm{3}));
end
% ---------------------------------------------------------------------------------------------------------


figure
plot(RRmean{1}, Fmaxm{1},'xr'); hold on
plot(RRmean{2}, Fmaxm{2},'xb');
plot(RRmean{3}, Fmaxm{3},'xg');
plot(RRr, Fmr,':k'); % draw the decision line

end;
% -----------------------------------------------------------------------------------------
%if(0)
MainDataPath=[MainDataDir,'\test-set-a'];
ResDataPath=fullfile(MainDataPath,'SptRes');
tipoC='a';
fprintf('%s\n', ResDataPath);
lista= dir(fullfile(ResDataPath, [tipoC,'*', '.mat']));
j=j+1;
for i=1:length(lista)
    [path, nname, ext] = fileparts(lista(i).name);
    fileName= fullfile(ResDataPath,lista(i).name);
%    fprintf('Reading parameters from file: %s\n', fileName);
    par{j}(i)=load(fileName);    %  RRs RRmean RRstd nc crr rp1fn rp2fn
    cname{j}{i}=nname;
end;
for i=1:size(par{j},2)
    Pdmaxm{j}(i)=par{j}(i).Pdmaxb;
    Fmaxm{j}(i)=par{j}(i).fPmaxb;
    RRmean{j}(i)=par{j}(i).RRmean;
end
HRmean{j}= 60./RRmean{j};

cTh{j}= 1 + (Fmaxm{j} > FpTh);
Cl{j}= 1 + (Fmaxm{j}> r_ang* RRmean{j} + r_int); 
% Cl{j}= 1 + (Fmaxm{j}> rh_ang* HRmean{j} + rh_int); 

fprintf('case\tcl\tcth\tFmaxm\tRRmean\n');
for i=1:size(cname{j},2) fprintf(' %s\t%d\t%d\t%6.3f\t%6.3f\n', cname{j}{i}, Cl{j}(i), cTh{j}(i), Fmaxm{j}(i),RRmean{j}(i)); end
fprintf('n. cases tipo 1 = %d,  %d\n', sum(Cl{j}==1), sum(cTh{j}==1));
fprintf('n. cases tipo 2 = %d,  %d\n', sum(Cl{j}==2), sum(cTh{j}==2));

if(WriteFile)
    % Write on file the results
    fprintf(fidw,'%s\n', ResDataPath);
    fprintf(fidw,'case\tcl\tcth\tFmaxm\tRRmean\n');
    for i=1:size(cname{j},2) fprintf(fidw,' %s\t%d\t%d\t%6.3f\t%6.3f\n', cname{j}{i}, Cl{j}(i), cTh{j}(i), Fmaxm{j}(i),RRmean{j}(i)); end
    
    fprintf(fidw,'n. cases tipo 1 = %d,  %d\n', sum(Cl{j}==1), sum(cTh{j}==1));
    fprintf(fidw,'n. cases tipo 2 = %d,  %d\n', sum(Cl{j}==2), sum(cTh{j}==2));
end

figure
plot(RRmean{j}, Fmaxm{j},'om'); hold on

for icn=1:length(casinotiaT)
    icasiknaT(icn)=find(strcmp(casinotiaT(icn),cname{j}));
end
for icn=1:length(casinotiaN)
    icasiknaN(icn)=find(strcmp(casinotiaN(icn),cname{j}));
end
plot(RRmean{j}(icasiknaT), Fmaxm{j}(icasiknaT),'xb'); hold on
plot(RRmean{j}(icasiknaN), Fmaxm{j}(icasiknaN),'xr'); hold on

plot(RRr, Fmr,':k'); % draw the decision line
%end

MainDataPath=[MainDataDir,'\test-set-b'];
ResDataPath=fullfile(MainDataPath,'SptRes');
tipoC='b';
fprintf('%s\n', ResDataPath);
lista= dir(fullfile(ResDataPath, [tipoC,'*', '.mat']));
if(~isempty(lista))
    j=j+1;
    for i=1:length(lista)
        [path, nname, ext] = fileparts(lista(i).name);
        fileName= fullfile(ResDataPath,lista(i).name);
%       fprintf('Reading parameters from file: %s\n', fileName);
        par{j}(i)=load(fileName);    %  RRs RRmean RRstd nc crr rp1fn rp2fn
        cname{j}{i}=nname;
    end;
    for i=1:size(par{j},2)
        Pdmaxm{j}(i)=par{j}(i).Pdmaxb;
        Fmaxm{j}(i)=par{j}(i).fPmaxb;
        RRmean{j}(i)=par{j}(i).RRmean;
    end
    HRmean{j}= 60./RRmean{j};
   
    cTh{j}= 1 + (Fmaxm{j} > FpTh);
    Cl{j}= 1 + (Fmaxm{j}> r_ang* RRmean{j} + r_int); 
%    Cl{j}= 1 + (Fmaxm{j}> rh_ang* HRmean{j} + rh_int); 

    fprintf('case\tcl\tFmaxm\tRRmean\n');
    for i=1:size(cname{j},2) fprintf(' %s\t%d\t%d\t%6.3f\t%6.3f\n', cname{j}{i}, Cl{j}(i), cTh{j}(i), Fmaxm{j}(i),RRmean{j}(i)); end
    fprintf('n. cases tipo 1 = %d,  %d\n', sum(Cl{j}==1), sum(cTh{j}==1));
    fprintf('n. cases tipo 2 = %d,  %d\n', sum(Cl{j}==2), sum(cTh{j}==2));
    
    if(WriteFile)
        % Write on file the results
        fprintf(fidw,'%s\n', ResDataPath);
        fprintf(fidw,'case\tcl\tcth\tFmaxm\tRRmean\n');
        for i=1:size(cname{j},2) fprintf(fidw,' %s\t%d\t%d\t%6.3f\t%6.3f\n', cname{j}{i}, cTh{j}(i), Cl{j}(i), Fmaxm{j}(i),RRmean{j}(i)); end
        
        fprintf(fidw,'n. cases tipo 1 = %d,  %d\n', sum(Cl{j}==1), sum(cTh{j}==1));
        fprintf(fidw,'n. cases tipo 2 = %d,  %d\n', sum(Cl{j}==2), sum(cTh{j}==2));
    end
    figure
    plot(RRmean{j}, Fmaxm{j},'og'); hold on
    for icn=1:length(casinotibT)
        icasiknbT(icn)=find(strcmp(casinotibT(icn),cname{j}));
    end
    for icn=1:length(casinotibS)
        icasiknbS(icn)=find(strcmp(casinotibS(icn),cname{j}));
    end
    plot(RRmean{j}(icasiknbT), Fmaxm{j}(icasiknbT),'xb'); hold on
    plot(RRmean{j}(icasiknbS), Fmaxm{j}(icasiknbS),'xg'); hold on

    plot(RRr, Fmr,':k'); % draw the decision line

end

nj=j;
figure; hold on;
marktype={'xr','xb','xg','om','og'};
for j=1:nj
    plot(RRmean{j}, Fmaxm{j},marktype{j}); 
end
j=4;
plot(RRmean{j}(icasiknaT), Fmaxm{j}(icasiknaT),'*b'); hold on
plot(RRmean{j}(icasiknaN), Fmaxm{j}(icasiknaN),'*r'); hold on
j=5;
plot(RRmean{j}(icasiknbT), Fmaxm{j}(icasiknbT),'*b'); hold on
plot(RRmean{j}(icasiknbS), Fmaxm{j}(icasiknbS),'*g'); hold on
plot(RRr, Fmr,':k'); % draw the decision line

figure; hold on;
for j=1:nj
    plot(HRmean{j}, Fmaxm{j},marktype{j}); 
end
j=4;
plot(HRmean{j}(icasiknaT), Fmaxm{j}(icasiknaT),'*b'); hold on
plot(HRmean{j}(icasiknaN), Fmaxm{j}(icasiknaN),'*r'); hold on
j=5;
plot(HRmean{j}(icasiknbT), Fmaxm{j}(icasiknbT),'*b'); hold on
plot(HRmean{j}(icasiknbS), Fmaxm{j}(icasiknbS),'*g'); hold on

plot(HRr, Fmrh,':k'); % draw the decision line

fclose(fidw);
