% -------------------------------------------------------------------------------------------------
% QrsAvgCancelAll.m: QRST canceling for all the cases in the subdirectories
%                    'learning-set', 'test-set-a', 'test-set-b' of the directory
%                    '..\..\www.physionet.org\physiobank\database\aftdb'.
% For each case a call to the routine 'QrsAvgCancelTestClpCan' is executed and
% the following files are written in the directory '..\..\DatiQc'
% 'casename.dat' containing signals after QRST canceling
% 'casename.mat' containing some parameters (RR interval series, the mean RR, ...)
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function QrsAvgCancelAll(mainPath_in, mainPath_out)

    if(nargin < 1)  mainPath_in='..\..\www.physionet.org\physiobank\database\aftdb'; end
    if(nargin < 2)  mainPath_out='..\..\'; end

    modifier='';
    
    casiDir='learning-set';
    tipoC='n'    %  N not terminated
    QrsAvgCancelDir(mainPath_in, casiDir, tipoC, modifier, mainPath_out );
    
    tipoC='s'    %  terminate after a minute 
    QrsAvgCancelDir(mainPath_in, casiDir, tipoC, modifier, mainPath_out );
    
    tipoC='t'    %  Terminate within a second after the end of the record
    QrsAvgCancelDir(mainPath_in, casiDir, tipoC, modifier, mainPath_out );
    
    casiDir='test-set-a';
    tipoC='a'    %  ??
    QrsAvgCancelDir(mainPath_in, casiDir, tipoC, modifier, mainPath_out );
    
    casiDir='test-set-b';
    tipoC='b'    %  ??
    QrsAvgCancelDir(mainPath_in, casiDir, tipoC, modifier, mainPath_out );
    
end    

function QrsAvgCancelDir(mainPath_in, casiDir, tipoC, modifier, mainPath_out )
fprintf('------------------- Start processing of %s ---------------------\n', casiDir);
lista= dir(fullfile(mainPath_in, casiDir, [tipoC,'*', modifier,'.dat']));
for i=1:length(lista)
    [path, nname, ext] = fileparts(lista(i).name); 
    QrsAvgCancelTestClpCan(mainPath_in, casiDir, nname, mainPath_out);
    close all;
end;
fprintf('----------------------- End of processing  ---------------------\n');

clear all