% -------------------------------------------------------------------------------------------------
% meanmaxsc.m: Compute the average value of the maxima computed on data windows of the input vector.
%              Distribution tails can be excluded using parameters "perci" and "percf"
%              "v" = input data vector
%              "nel" = data window length
%              "perci" = % of min values;  "percf" = % of max values to be excluded
%
% Copyright (C) 2004 Maurizio Varanini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: maurizio.varanini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function me = meanMaxSc(v,nel,percmi,percma)
j=1;
for i=1:nel:length(v)-nel
    maxi(j)=max(v(i:i+nel-1));
    j=j+1;
end
if(percmi<0) ii=1-percmi;
else ii=1+floor(length(maxi)*percmi/100); end
if(percma<0) fi=length(maxi)+percma;
else fi=length(maxi)-floor(length(maxi)*percma/100); end
omaxi=sort(maxi);
me=mean(omaxi(ii:fi));
