% -------------------------------------------------------------------------------------------------
% EventB.m: 
%
% Copyright (C) 2004 Federico Cantini, Clinical Physiology Institute, CNR, Pisa, Italy
%
% This program is free software; you can redistribute it and/or modify it under the terms
% of the GNU General Public License as published by the Free Software Foundation; either
% version 2 of the License, or (at your option) any later version.
%
% This program is distributed "as is" and "as available" in the hope that it will be useful,
% but WITHOUT ANY WARRANTY of any kind; without even the implied warranty of MERCHANTABILITY
% or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License along with this program;
% if not, write to the Free Software Foundation, Inc.,
% 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
%
% For any comment or bug report, please send e-mail to: federico.cantini@ifc.cnr.it
% -------------------------------------------------------------------------------------------------

function EventB (mainPath_in, mainPath)

record_learn ={'t01','t02','t03','t04','t05','t06','t07','t08','t09','t10','s01','s02','s03','s04','s05','s06','s07','s08','s09','s10'};
record_test ={'b19','b16','b03','b07','b12','b13','b17','b18','b15','b08','b05','b14','b01','b02','b20','b04','b06','b11','b10','b09'};

if nargin < 1
%%--------Atrial fibrillation test database Main Direcory---------------------------------
    mainPath_in='C:\documents and Settings\federico\Documenti\CinC2004\RR_FBA\cantini\aftdb\';
%%----------------------------------------------------------------------------------------
end
if nargin < 2
%%-------- Main Data Directory-------------------------------------------------------------
    mainPath='.\';
%%----------------------------------------------------------------------------------------
end

casiDir='learning-set';
for ii = 1:length(record_learn)
    	file = [record_learn{ii},'.dat'];
        QrsAvgCancelTestClp(mainPath_in, casiDir, record_learn{ii}, mainPath);
end

casiDir='test-set-b';
for ii = 1:length(record_test)
    	file = [record_test{ii},'.dat'];
        QrsAvgCancelTestClp(mainPath_in, casiDir, record_test{ii}, mainPath);
end

   learnC = TSmerge (mainPath, 'learning-set', record_learn);
   testC  = TSmerge (mainPath, 'test-set-b', record_test);

casiDir='learning-set';
for ii = 1:length(record_learn)
     	file = [record_learn{ii},'.dat'];
         QrsAvgCancelTestClp_SC(mainPath_in, casiDir, record_learn{ii}, mainPath);
end
 
 casiDir='test-set-b';
 for ii = 1:length(record_test)
    	file = [record_test{ii},'.dat'];
         QrsAvgCancelTestClp_SC(mainPath_in, casiDir, record_test{ii}, mainPath);
end


for ii = 1:length(learnC)
      learnRes(ii) = SpettriEvB([mainPath 'DatiQc\'],'learning-set',learnC{ii,1},learnC{ii,2});
end     

for ii = 1:length(testC)
      testRes(ii) = SpettriEvB([mainPath 'DatiQc\'],'test-set-b',testC{ii,1},testC{ii,2});
end     


for ii = 1:length(learnRes)
    if learnRes(ii) > 0 fprintf('%s -> T \t %s -> S\n',learnC{ii,1},learnC{ii,2}); end
    if learnRes(ii) < 0 fprintf('%s -> T \t %s -> S\n',learnC{ii,2},learnC{ii,1}); end
end

fprintf('\n\n');

for ii = 1:length(testRes)
    if testRes(ii) > 0 fprintf('%s -> T \t %s -> S\n',testC{ii,1},testC{ii,2}); end
    if testRes(ii) < 0 fprintf('%s -> T \t %s -> S\n',testC{ii,2},testC{ii,1}); end
end
