/* file: analyze.c

This file is a template for a challenge entry.  Replace the contents
of initialize(), analyze(), and finalize() with your own code.  You
may define other functions in this file if necessary;  do not redefine
main(), label(), open_files(), or close_input().

Before submitting your entry, don't forget to fill in your name,
organization, and email address below!

   Author(s)     : 
   Organization  : 
   email address : 

*/

/* Comment out any of these that the algorithm will not need. */
#if !defined(NOWFDB)
#define USE_DAT		/* open the .dat (digitized ECG) file */
#define USE_ANN		/* open the .atr and .16a annotation files */
#endif
#define USE_STF		/* open the .stf (ST level function) file */
#define USE_KLT		/* open the .klt (QRS, ST principal components) file */

/* The variables defined here are initialized by the main program after
   initialize() is invoked, but before analyze() is called.  Do not change
   their values! */

#if defined(USE_DAT) || defined(USE_ANN)
#include <wfdb/wfdb.h>
int nsig;		/* number of input signals (2 or 3) */
/* To read a sample at time t from signal s, use code such as
        v = sample(s, t);
   where
        s is the signal number (0, 1, or 2)
        t is elapsed time from the first sample (at t=0) in sample intervals
          (1 sample interval = 4 milliseconds)
        v is the unscaled digitizer output (-2048 to +2047);  -2048 corresponds
	  to -10.24 millivolts, and +2047 corresponds to +10.23 millivolts

   To read annotations, declare a WFDB_Annotation object:
        WFDB_Annotation a;
   Use
        getann(0, &a);
   to read the next annotation from the .atr file, or
        getann(1, &a);
   to read the next annotation from the .16a file.

   The contents of the annotation can then be read from 'a':
         a.time is the elapsed time of the annotation in sample intervals
	 a.anntyp is a code indicating the annotation type; use
	        #include <wfdb/ecgcodes.h>
	    to obtain symbolic definitions of the various annotation codes
         a.aux is a string describing the event at a.time;  the first byte
             indicates the length of the remainder of the string in bytes
	     (1 to 254)
   'a' contains other attributes that are not significant in these files.

   For additional information, see the WFDB Programmer's Guide at
       http://www.physionet.org/physiotools/wpg/
*/
#endif

#if defined(USE_STF)
FILE *stffile;		/* may be used to read the contents of the .stf file */
#endif

#if defined(USE_KLT)
FILE *kltfile;		/* may be used to read the contents of the .klt file */
#endif

/* label() is defined in stclass.c -- use it to record your classifications */
void label(int event_id, char event_label);

void initialize(void)	/* called once, before input files are opened */
{
    fprintf(stderr, "Initializing ...");
}

void analyze(int event_id, long event_time, int event_sig)
{			/* called once per event, in event_id order */
    fprintf(stderr, "Event ID: %d  Time: %ld  Signal: %d\n",
	    event_id, event_time, event_sig);

    /* This example labels odd-numbered events as ischemic ... */
    if (event_id & 1)
	label(event_id, 'I');
    /* and even-numbered events as non-ischemic ... */
    else
	label(event_id, 'N');
    /* and then relabels every tenth event as indeterminate. */
    if (event_id % 10 == 0)
	label(event_id, '?');
    /* Obviously, this is a poor algorithm;  replace it with one that works! */
}

void finalize(void)	/* called once, after input files are closed, but
			   before the .epo file has been written */
{
    fprintf(stderr, "done!\n");
}
